/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.AutoExportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobInner;
import com.azure.resourcemanager.storagecache.implementation.AutoExportJobImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.AutoExportJob;
import com.azure.resourcemanager.storagecache.models.AutoExportJobs;

public final class AutoExportJobsImpl
implements AutoExportJobs {
    private static final ClientLogger LOGGER = new ClientLogger(AutoExportJobsImpl.class);
    private final AutoExportJobsClient innerClient;
    private final StorageCacheManager serviceManager;

    public AutoExportJobsImpl(AutoExportJobsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName, autoExportJobName);
    }

    @Override
    public void delete(String resourceGroupName, String amlFilesystemName, String autoExportJobName, Context context) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName, autoExportJobName, context);
    }

    @Override
    public Response<AutoExportJob> getWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName, Context context) {
        Response<AutoExportJobInner> inner = this.serviceClient().getWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AutoExportJobImpl((AutoExportJobInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AutoExportJob get(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        AutoExportJobInner inner = this.serviceClient().get(resourceGroupName, amlFilesystemName, autoExportJobName);
        if (inner != null) {
            return new AutoExportJobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AutoExportJob> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        PagedIterable<AutoExportJobInner> inner = this.serviceClient().listByAmlFilesystem(resourceGroupName, amlFilesystemName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoExportJobImpl((AutoExportJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AutoExportJob> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName, Context context) {
        PagedIterable<AutoExportJobInner> inner = this.serviceClient().listByAmlFilesystem(resourceGroupName, amlFilesystemName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AutoExportJobImpl((AutoExportJobInner)((Object)inner1), this.manager()));
    }

    @Override
    public AutoExportJob getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoExportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoExportJobs");
        if (autoExportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoExportJobs'.", id)));
        }
        return (AutoExportJob)this.getWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, Context.NONE).getValue();
    }

    @Override
    public Response<AutoExportJob> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoExportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoExportJobs");
        if (autoExportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoExportJobs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoExportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoExportJobs");
        if (autoExportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoExportJobs'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, autoExportJobName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        String autoExportJobName = ResourceManagerUtils.getValueFromIdByName(id, "autoExportJobs");
        if (autoExportJobName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'autoExportJobs'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, autoExportJobName, context);
    }

    private AutoExportJobsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutoExportJobImpl define(String name) {
        return new AutoExportJobImpl(name, this.manager());
    }
}

