/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storagecache.fluent.AutoExportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobInner;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientImpl;
import com.azure.resourcemanager.storagecache.models.AutoExportJobUpdate;
import com.azure.resourcemanager.storagecache.models.AutoExportJobsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AutoExportJobsClientImpl
implements AutoExportJobsClient {
    private final AutoExportJobsService service;
    private final StorageCacheManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AutoExportJobsClientImpl.class);

    AutoExportJobsClientImpl(StorageCacheManagementClientImpl client) {
        this.service = (AutoExportJobsService)RestProxy.create(AutoExportJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoExportJobName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoExportJobName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoExportJobName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, amlFilesystemName, autoExportJobName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String amlFilesystemName, String autoExportJobName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        return this.beginDeleteAsync(resourceGroupName, amlFilesystemName, autoExportJobName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        this.beginDelete(resourceGroupName, amlFilesystemName, autoExportJobName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String amlFilesystemName, String autoExportJobName, Context context) {
        this.beginDelete(resourceGroupName, amlFilesystemName, autoExportJobName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AutoExportJobInner>> getWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoExportJobName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AutoExportJobInner> getAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        return this.getWithResponseAsync(resourceGroupName, amlFilesystemName, autoExportJobName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AutoExportJobInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AutoExportJobInner> getWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoExportJobName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoExportJobInner get(String resourceGroupName, String amlFilesystemName, String autoExportJobName) {
        return (AutoExportJobInner)((Object)this.getWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        if (autoExportJob == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoExportJob is required and cannot be null."));
        }
        autoExportJob.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoExportJobName, autoExportJob, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        if (autoExportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJob is required and cannot be null."));
        }
        autoExportJob.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoExportJobName, autoExportJob, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        if (autoExportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJob is required and cannot be null."));
        }
        autoExportJob.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoExportJobName, autoExportJob, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AutoExportJobInner>, AutoExportJobInner> beginCreateOrUpdateAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AutoExportJobInner.class), (Type)((Object)AutoExportJobInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoExportJobInner>, AutoExportJobInner> beginCreateOrUpdate(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob);
        return this.client.getLroResult(response, (Type)((Object)AutoExportJobInner.class), (Type)((Object)AutoExportJobInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoExportJobInner>, AutoExportJobInner> beginCreateOrUpdate(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob, context);
        return this.client.getLroResult(response, (Type)((Object)AutoExportJobInner.class), (Type)((Object)AutoExportJobInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AutoExportJobInner> createOrUpdateAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoExportJobInner createOrUpdate(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob) {
        return (AutoExportJobInner)((Object)this.beginCreateOrUpdate(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoExportJobInner createOrUpdate(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobInner autoExportJob, Context context) {
        return (AutoExportJobInner)((Object)this.beginCreateOrUpdate(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        if (autoExportJob == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoExportJob is required and cannot be null."));
        }
        autoExportJob.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoExportJobName, autoExportJob, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        if (autoExportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJob is required and cannot be null."));
        }
        autoExportJob.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoExportJobName, autoExportJob, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoExportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJobName is required and cannot be null."));
        }
        if (autoExportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoExportJob is required and cannot be null."));
        }
        autoExportJob.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoExportJobName, autoExportJob, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AutoExportJobInner>, AutoExportJobInner> beginUpdateAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AutoExportJobInner.class), (Type)((Object)AutoExportJobInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoExportJobInner>, AutoExportJobInner> beginUpdate(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob);
        return this.client.getLroResult(response, (Type)((Object)AutoExportJobInner.class), (Type)((Object)AutoExportJobInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoExportJobInner>, AutoExportJobInner> beginUpdate(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob, context);
        return this.client.getLroResult(response, (Type)((Object)AutoExportJobInner.class), (Type)((Object)AutoExportJobInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AutoExportJobInner> updateAsync(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob) {
        return this.beginUpdateAsync(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoExportJobInner update(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob) {
        return (AutoExportJobInner)((Object)this.beginUpdate(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoExportJobInner update(String resourceGroupName, String amlFilesystemName, String autoExportJobName, AutoExportJobUpdate autoExportJob, Context context) {
        return (AutoExportJobInner)((Object)this.beginUpdate(resourceGroupName, amlFilesystemName, autoExportJobName, autoExportJob, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AutoExportJobInner>> listByAmlFilesystemSinglePageAsync(String resourceGroupName, String amlFilesystemName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAmlFilesystem(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoExportJobsListResult)res.getValue()).value(), ((AutoExportJobsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AutoExportJobInner> listByAmlFilesystemAsync(String resourceGroupName, String amlFilesystemName) {
        return new PagedFlux(() -> this.listByAmlFilesystemSinglePageAsync(resourceGroupName, amlFilesystemName), nextLink -> this.listByAmlFilesystemNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoExportJobInner> listByAmlFilesystemSinglePage(String resourceGroupName, String amlFilesystemName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoExportJobsListResult> res = this.service.listByAmlFilesystemSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoExportJobsListResult)res.getValue()).value(), ((AutoExportJobsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoExportJobInner> listByAmlFilesystemSinglePage(String resourceGroupName, String amlFilesystemName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoExportJobsListResult> res = this.service.listByAmlFilesystemSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoExportJobsListResult)res.getValue()).value(), ((AutoExportJobsListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AutoExportJobInner> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        return new PagedIterable(() -> this.listByAmlFilesystemSinglePage(resourceGroupName, amlFilesystemName), nextLink -> this.listByAmlFilesystemNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AutoExportJobInner> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName, Context context) {
        return new PagedIterable(() -> this.listByAmlFilesystemSinglePage(resourceGroupName, amlFilesystemName, context), nextLink -> this.listByAmlFilesystemNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AutoExportJobInner>> listByAmlFilesystemNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAmlFilesystemNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoExportJobsListResult)res.getValue()).value(), ((AutoExportJobsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoExportJobInner> listByAmlFilesystemNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoExportJobsListResult> res = this.service.listByAmlFilesystemNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoExportJobsListResult)res.getValue()).value(), ((AutoExportJobsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoExportJobInner> listByAmlFilesystemNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoExportJobsListResult> res = this.service.listByAmlFilesystemNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoExportJobsListResult)res.getValue()).value(), ((AutoExportJobsListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageCacheManagementClientAutoExportJobs")
    public static interface AutoExportJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoExportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoExportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AutoExportJobInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoExportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AutoExportJobInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoExportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoExportJobName") String var6, @BodyParam(value="application/json") AutoExportJobInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoExportJobName") String var6, @BodyParam(value="application/json") AutoExportJobInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoExportJobName") String var6, @BodyParam(value="application/json") AutoExportJobUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs/{autoExportJobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoExportJobName") String var6, @BodyParam(value="application/json") AutoExportJobUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AutoExportJobsListResult>> listByAmlFilesystem(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoExportJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AutoExportJobsListResult> listByAmlFilesystemSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AutoExportJobsListResult>> listByAmlFilesystemNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AutoExportJobsListResult> listByAmlFilesystemNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

