/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.AscUsagesClient;
import com.azure.resourcemanager.storagecache.fluent.models.ResourceUsageInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.implementation.ResourceUsageImpl;
import com.azure.resourcemanager.storagecache.models.AscUsages;
import com.azure.resourcemanager.storagecache.models.ResourceUsage;

public final class AscUsagesImpl
implements AscUsages {
    private static final ClientLogger LOGGER = new ClientLogger(AscUsagesImpl.class);
    private final AscUsagesClient innerClient;
    private final StorageCacheManager serviceManager;

    public AscUsagesImpl(AscUsagesClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ResourceUsage> list(String location) {
        PagedIterable<ResourceUsageInner> inner = this.serviceClient().list(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceUsageImpl((ResourceUsageInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ResourceUsage> list(String location, Context context) {
        PagedIterable<ResourceUsageInner> inner = this.serviceClient().list(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceUsageImpl((ResourceUsageInner)inner1, this.manager()));
    }

    private AscUsagesClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }
}

