/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.AmlFilesystemsClient;
import com.azure.resourcemanager.storagecache.fluent.models.AmlFilesystemInner;
import com.azure.resourcemanager.storagecache.implementation.AmlFilesystemImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.AmlFilesystem;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemArchiveInfo;
import com.azure.resourcemanager.storagecache.models.AmlFilesystems;

public final class AmlFilesystemsImpl
implements AmlFilesystems {
    private static final ClientLogger LOGGER = new ClientLogger(AmlFilesystemsImpl.class);
    private final AmlFilesystemsClient innerClient;
    private final StorageCacheManager serviceManager;

    public AmlFilesystemsImpl(AmlFilesystemsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AmlFilesystem> list() {
        PagedIterable<AmlFilesystemInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AmlFilesystemImpl((AmlFilesystemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AmlFilesystem> list(Context context) {
        PagedIterable<AmlFilesystemInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AmlFilesystemImpl((AmlFilesystemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AmlFilesystem> listByResourceGroup(String resourceGroupName) {
        PagedIterable<AmlFilesystemInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AmlFilesystemImpl((AmlFilesystemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AmlFilesystem> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<AmlFilesystemInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AmlFilesystemImpl((AmlFilesystemInner)((Object)inner1), this.manager()));
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String amlFilesystemName) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName);
    }

    @Override
    public void delete(String resourceGroupName, String amlFilesystemName, Context context) {
        this.serviceClient().delete(resourceGroupName, amlFilesystemName, context);
    }

    @Override
    public Response<AmlFilesystem> getByResourceGroupWithResponse(String resourceGroupName, String amlFilesystemName, Context context) {
        Response<AmlFilesystemInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, amlFilesystemName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AmlFilesystemImpl((AmlFilesystemInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AmlFilesystem getByResourceGroup(String resourceGroupName, String amlFilesystemName) {
        AmlFilesystemInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, amlFilesystemName);
        if (inner != null) {
            return new AmlFilesystemImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> archiveWithResponse(String resourceGroupName, String amlFilesystemName, AmlFilesystemArchiveInfo archiveInfo, Context context) {
        return this.serviceClient().archiveWithResponse(resourceGroupName, amlFilesystemName, archiveInfo, context);
    }

    @Override
    public void archive(String resourceGroupName, String amlFilesystemName) {
        this.serviceClient().archive(resourceGroupName, amlFilesystemName);
    }

    @Override
    public Response<Void> cancelArchiveWithResponse(String resourceGroupName, String amlFilesystemName, Context context) {
        return this.serviceClient().cancelArchiveWithResponse(resourceGroupName, amlFilesystemName, context);
    }

    @Override
    public void cancelArchive(String resourceGroupName, String amlFilesystemName) {
        this.serviceClient().cancelArchive(resourceGroupName, amlFilesystemName);
    }

    @Override
    public AmlFilesystem getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        return (AmlFilesystem)this.getByResourceGroupWithResponse(resourceGroupName, amlFilesystemName, Context.NONE).getValue();
    }

    @Override
    public Response<AmlFilesystem> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, amlFilesystemName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(id, "amlFilesystems");
        if (amlFilesystemName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'amlFilesystems'.", id)));
        }
        this.delete(resourceGroupName, amlFilesystemName, context);
    }

    private AmlFilesystemsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public AmlFilesystemImpl define(String name) {
        return new AmlFilesystemImpl(name, this.manager());
    }
}

