/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.UsageModelDisplay;
import java.io.IOException;

public final class UsageModelInner
implements JsonSerializable<UsageModelInner> {
    private UsageModelDisplay display;
    private String modelName;
    private String targetType;

    public UsageModelDisplay display() {
        return this.display;
    }

    public UsageModelInner withDisplay(UsageModelDisplay display) {
        this.display = display;
        return this;
    }

    public String modelName() {
        return this.modelName;
    }

    public UsageModelInner withModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public String targetType() {
        return this.targetType;
    }

    public UsageModelInner withTargetType(String targetType) {
        this.targetType = targetType;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("modelName", this.modelName);
        jsonWriter.writeStringField("targetType", this.targetType);
        return jsonWriter.writeEndObject();
    }

    public static UsageModelInner fromJson(JsonReader jsonReader) throws IOException {
        return (UsageModelInner)jsonReader.readObject(reader -> {
            UsageModelInner deserializedUsageModelInner = new UsageModelInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("display".equals(fieldName)) {
                    deserializedUsageModelInner.display = UsageModelDisplay.fromJson(reader);
                    continue;
                }
                if ("modelName".equals(fieldName)) {
                    deserializedUsageModelInner.modelName = reader.getString();
                    continue;
                }
                if ("targetType".equals(fieldName)) {
                    deserializedUsageModelInner.targetType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageModelInner;
        });
    }
}

