/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.BlobNfsTarget;
import com.azure.resourcemanager.storagecache.models.ClfsTarget;
import com.azure.resourcemanager.storagecache.models.NamespaceJunction;
import com.azure.resourcemanager.storagecache.models.Nfs3Target;
import com.azure.resourcemanager.storagecache.models.OperationalStateType;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTargetType;
import com.azure.resourcemanager.storagecache.models.UnknownTarget;
import java.io.IOException;
import java.util.List;

public final class StorageTargetProperties
implements JsonSerializable<StorageTargetProperties> {
    private List<NamespaceJunction> junctions;
    private StorageTargetType targetType;
    private ProvisioningStateType provisioningState;
    private OperationalStateType state;
    private Nfs3Target nfs3;
    private ClfsTarget clfs;
    private UnknownTarget unknown;
    private BlobNfsTarget blobNfs;
    private Integer allocationPercentage;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTargetProperties.class);

    public List<NamespaceJunction> junctions() {
        return this.junctions;
    }

    public StorageTargetProperties withJunctions(List<NamespaceJunction> junctions) {
        this.junctions = junctions;
        return this;
    }

    public StorageTargetType targetType() {
        return this.targetType;
    }

    public StorageTargetProperties withTargetType(StorageTargetType targetType) {
        this.targetType = targetType;
        return this;
    }

    public ProvisioningStateType provisioningState() {
        return this.provisioningState;
    }

    public OperationalStateType state() {
        return this.state;
    }

    public StorageTargetProperties withState(OperationalStateType state) {
        this.state = state;
        return this;
    }

    public Nfs3Target nfs3() {
        return this.nfs3;
    }

    public StorageTargetProperties withNfs3(Nfs3Target nfs3) {
        this.nfs3 = nfs3;
        return this;
    }

    public ClfsTarget clfs() {
        return this.clfs;
    }

    public StorageTargetProperties withClfs(ClfsTarget clfs) {
        this.clfs = clfs;
        return this;
    }

    public UnknownTarget unknown() {
        return this.unknown;
    }

    public StorageTargetProperties withUnknown(UnknownTarget unknown) {
        this.unknown = unknown;
        return this;
    }

    public BlobNfsTarget blobNfs() {
        return this.blobNfs;
    }

    public StorageTargetProperties withBlobNfs(BlobNfsTarget blobNfs) {
        this.blobNfs = blobNfs;
        return this;
    }

    public Integer allocationPercentage() {
        return this.allocationPercentage;
    }

    public void validate() {
        if (this.junctions() != null) {
            this.junctions().forEach(e -> e.validate());
        }
        if (this.targetType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetType in model StorageTargetProperties"));
        }
        if (this.nfs3() != null) {
            this.nfs3().validate();
        }
        if (this.clfs() != null) {
            this.clfs().validate();
        }
        if (this.unknown() != null) {
            this.unknown().validate();
        }
        if (this.blobNfs() != null) {
            this.blobNfs().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetType", this.targetType == null ? null : this.targetType.toString());
        jsonWriter.writeArrayField("junctions", this.junctions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("nfs3", (JsonSerializable)this.nfs3);
        jsonWriter.writeJsonField("clfs", (JsonSerializable)this.clfs);
        jsonWriter.writeJsonField("unknown", (JsonSerializable)this.unknown);
        jsonWriter.writeJsonField("blobNfs", (JsonSerializable)this.blobNfs);
        return jsonWriter.writeEndObject();
    }

    public static StorageTargetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTargetProperties)jsonReader.readObject(reader -> {
            StorageTargetProperties deserializedStorageTargetProperties = new StorageTargetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetType".equals(fieldName)) {
                    deserializedStorageTargetProperties.targetType = StorageTargetType.fromString(reader.getString());
                    continue;
                }
                if ("junctions".equals(fieldName)) {
                    List junctions;
                    deserializedStorageTargetProperties.junctions = junctions = reader.readArray(reader1 -> NamespaceJunction.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageTargetProperties.provisioningState = ProvisioningStateType.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedStorageTargetProperties.state = OperationalStateType.fromString(reader.getString());
                    continue;
                }
                if ("nfs3".equals(fieldName)) {
                    deserializedStorageTargetProperties.nfs3 = Nfs3Target.fromJson(reader);
                    continue;
                }
                if ("clfs".equals(fieldName)) {
                    deserializedStorageTargetProperties.clfs = ClfsTarget.fromJson(reader);
                    continue;
                }
                if ("unknown".equals(fieldName)) {
                    deserializedStorageTargetProperties.unknown = UnknownTarget.fromJson(reader);
                    continue;
                }
                if ("blobNfs".equals(fieldName)) {
                    deserializedStorageTargetProperties.blobNfs = BlobNfsTarget.fromJson(reader);
                    continue;
                }
                if ("allocationPercentage".equals(fieldName)) {
                    deserializedStorageTargetProperties.allocationPercentage = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTargetProperties;
        });
    }
}

