/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.StorageTargetProperties;
import com.azure.resourcemanager.storagecache.models.BlobNfsTarget;
import com.azure.resourcemanager.storagecache.models.ClfsTarget;
import com.azure.resourcemanager.storagecache.models.NamespaceJunction;
import com.azure.resourcemanager.storagecache.models.Nfs3Target;
import com.azure.resourcemanager.storagecache.models.OperationalStateType;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTargetResource;
import com.azure.resourcemanager.storagecache.models.StorageTargetType;
import com.azure.resourcemanager.storagecache.models.UnknownTarget;
import java.io.IOException;
import java.util.List;

public final class StorageTargetInner
extends StorageTargetResource {
    private StorageTargetProperties innerProperties;
    private SystemData systemData;
    private String location;
    private String type;
    private String name;
    private String id;

    private StorageTargetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public List<NamespaceJunction> junctions() {
        return this.innerProperties() == null ? null : this.innerProperties().junctions();
    }

    public StorageTargetInner withJunctions(List<NamespaceJunction> junctions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageTargetProperties();
        }
        this.innerProperties().withJunctions(junctions);
        return this;
    }

    public StorageTargetType targetType() {
        return this.innerProperties() == null ? null : this.innerProperties().targetType();
    }

    public StorageTargetInner withTargetType(StorageTargetType targetType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageTargetProperties();
        }
        this.innerProperties().withTargetType(targetType);
        return this;
    }

    public ProvisioningStateType provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OperationalStateType state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public StorageTargetInner withState(OperationalStateType state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageTargetProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public Nfs3Target nfs3() {
        return this.innerProperties() == null ? null : this.innerProperties().nfs3();
    }

    public StorageTargetInner withNfs3(Nfs3Target nfs3) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageTargetProperties();
        }
        this.innerProperties().withNfs3(nfs3);
        return this;
    }

    public ClfsTarget clfs() {
        return this.innerProperties() == null ? null : this.innerProperties().clfs();
    }

    public StorageTargetInner withClfs(ClfsTarget clfs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageTargetProperties();
        }
        this.innerProperties().withClfs(clfs);
        return this;
    }

    public UnknownTarget unknown() {
        return this.innerProperties() == null ? null : this.innerProperties().unknown();
    }

    public StorageTargetInner withUnknown(UnknownTarget unknown) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageTargetProperties();
        }
        this.innerProperties().withUnknown(unknown);
        return this;
    }

    public BlobNfsTarget blobNfs() {
        return this.innerProperties() == null ? null : this.innerProperties().blobNfs();
    }

    public StorageTargetInner withBlobNfs(BlobNfsTarget blobNfs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageTargetProperties();
        }
        this.innerProperties().withBlobNfs(blobNfs);
        return this;
    }

    public Integer allocationPercentage() {
        return this.innerProperties() == null ? null : this.innerProperties().allocationPercentage();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StorageTargetInner fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTargetInner)((Object)jsonReader.readObject(reader -> {
            StorageTargetInner deserializedStorageTargetInner = new StorageTargetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageTargetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageTargetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageTargetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedStorageTargetInner.location = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedStorageTargetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageTargetInner.innerProperties = StorageTargetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTargetInner;
        }));
    }
}

