/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.ImportStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ImportJobPropertiesStatus
implements JsonSerializable<ImportJobPropertiesStatus> {
    private ImportStatusType state;
    private String statusMessage;
    private Long totalBlobsWalked;
    private Long blobsWalkedPerSecond;
    private Long totalBlobsImported;
    private Long importedFiles;
    private Long importedDirectories;
    private Long importedSymlinks;
    private Long preexistingFiles;
    private Long preexistingDirectories;
    private Long preexistingSymlinks;
    private Long blobsImportedPerSecond;
    private OffsetDateTime lastCompletionTime;
    private OffsetDateTime lastStartedTime;
    private Integer totalErrors;
    private Integer totalConflicts;

    public ImportStatusType state() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Long totalBlobsWalked() {
        return this.totalBlobsWalked;
    }

    public Long blobsWalkedPerSecond() {
        return this.blobsWalkedPerSecond;
    }

    public Long totalBlobsImported() {
        return this.totalBlobsImported;
    }

    public Long importedFiles() {
        return this.importedFiles;
    }

    public Long importedDirectories() {
        return this.importedDirectories;
    }

    public Long importedSymlinks() {
        return this.importedSymlinks;
    }

    public Long preexistingFiles() {
        return this.preexistingFiles;
    }

    public Long preexistingDirectories() {
        return this.preexistingDirectories;
    }

    public Long preexistingSymlinks() {
        return this.preexistingSymlinks;
    }

    public Long blobsImportedPerSecond() {
        return this.blobsImportedPerSecond;
    }

    public OffsetDateTime lastCompletionTime() {
        return this.lastCompletionTime;
    }

    public OffsetDateTime lastStartedTime() {
        return this.lastStartedTime;
    }

    public Integer totalErrors() {
        return this.totalErrors;
    }

    public Integer totalConflicts() {
        return this.totalConflicts;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ImportJobPropertiesStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ImportJobPropertiesStatus)jsonReader.readObject(reader -> {
            ImportJobPropertiesStatus deserializedImportJobPropertiesStatus = new ImportJobPropertiesStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.state = ImportStatusType.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.statusMessage = reader.getString();
                    continue;
                }
                if ("totalBlobsWalked".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.totalBlobsWalked = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("blobsWalkedPerSecond".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.blobsWalkedPerSecond = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalBlobsImported".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.totalBlobsImported = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("importedFiles".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.importedFiles = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("importedDirectories".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.importedDirectories = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("importedSymlinks".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.importedSymlinks = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("preexistingFiles".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.preexistingFiles = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("preexistingDirectories".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.preexistingDirectories = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("preexistingSymlinks".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.preexistingSymlinks = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("blobsImportedPerSecond".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.blobsImportedPerSecond = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lastCompletionTime".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.lastCompletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStartedTime".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.lastStartedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("totalErrors".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.totalErrors = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("totalConflicts".equals(fieldName)) {
                    deserializedImportJobPropertiesStatus.totalConflicts = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportJobPropertiesStatus;
        });
    }
}

