/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobPropertiesStatus;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import com.azure.resourcemanager.storagecache.models.ImportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.ImportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.ImportStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ImportJobProperties
implements JsonSerializable<ImportJobProperties> {
    private ImportJobProvisioningStateType provisioningState;
    private ImportJobAdminStatus adminStatus;
    private List<String> importPrefixes;
    private ConflictResolutionMode conflictResolutionMode;
    private Integer maximumErrors;
    private ImportJobPropertiesStatus innerStatus;

    public ImportJobProvisioningStateType provisioningState() {
        return this.provisioningState;
    }

    public ImportJobAdminStatus adminStatus() {
        return this.adminStatus;
    }

    public ImportJobProperties withAdminStatus(ImportJobAdminStatus adminStatus) {
        this.adminStatus = adminStatus;
        return this;
    }

    public List<String> importPrefixes() {
        return this.importPrefixes;
    }

    public ImportJobProperties withImportPrefixes(List<String> importPrefixes) {
        this.importPrefixes = importPrefixes;
        return this;
    }

    public ConflictResolutionMode conflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    public ImportJobProperties withConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        this.conflictResolutionMode = conflictResolutionMode;
        return this;
    }

    public Integer maximumErrors() {
        return this.maximumErrors;
    }

    public ImportJobProperties withMaximumErrors(Integer maximumErrors) {
        this.maximumErrors = maximumErrors;
        return this;
    }

    private ImportJobPropertiesStatus innerStatus() {
        return this.innerStatus;
    }

    public ImportStatusType state() {
        return this.innerStatus() == null ? null : this.innerStatus().state();
    }

    public String statusMessage() {
        return this.innerStatus() == null ? null : this.innerStatus().statusMessage();
    }

    public Long totalBlobsWalked() {
        return this.innerStatus() == null ? null : this.innerStatus().totalBlobsWalked();
    }

    public Long blobsWalkedPerSecond() {
        return this.innerStatus() == null ? null : this.innerStatus().blobsWalkedPerSecond();
    }

    public Long totalBlobsImported() {
        return this.innerStatus() == null ? null : this.innerStatus().totalBlobsImported();
    }

    public Long importedFiles() {
        return this.innerStatus() == null ? null : this.innerStatus().importedFiles();
    }

    public Long importedDirectories() {
        return this.innerStatus() == null ? null : this.innerStatus().importedDirectories();
    }

    public Long importedSymlinks() {
        return this.innerStatus() == null ? null : this.innerStatus().importedSymlinks();
    }

    public Long preexistingFiles() {
        return this.innerStatus() == null ? null : this.innerStatus().preexistingFiles();
    }

    public Long preexistingDirectories() {
        return this.innerStatus() == null ? null : this.innerStatus().preexistingDirectories();
    }

    public Long preexistingSymlinks() {
        return this.innerStatus() == null ? null : this.innerStatus().preexistingSymlinks();
    }

    public Long blobsImportedPerSecond() {
        return this.innerStatus() == null ? null : this.innerStatus().blobsImportedPerSecond();
    }

    public OffsetDateTime lastCompletionTime() {
        return this.innerStatus() == null ? null : this.innerStatus().lastCompletionTime();
    }

    public OffsetDateTime lastStartedTime() {
        return this.innerStatus() == null ? null : this.innerStatus().lastStartedTime();
    }

    public Integer totalErrors() {
        return this.innerStatus() == null ? null : this.innerStatus().totalErrors();
    }

    public Integer totalConflicts() {
        return this.innerStatus() == null ? null : this.innerStatus().totalConflicts();
    }

    public void validate() {
        if (this.innerStatus() != null) {
            this.innerStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminStatus", this.adminStatus == null ? null : this.adminStatus.toString());
        jsonWriter.writeArrayField("importPrefixes", this.importPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("conflictResolutionMode", this.conflictResolutionMode == null ? null : this.conflictResolutionMode.toString());
        jsonWriter.writeNumberField("maximumErrors", (Number)this.maximumErrors);
        return jsonWriter.writeEndObject();
    }

    public static ImportJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ImportJobProperties)jsonReader.readObject(reader -> {
            ImportJobProperties deserializedImportJobProperties = new ImportJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedImportJobProperties.provisioningState = ImportJobProvisioningStateType.fromString(reader.getString());
                    continue;
                }
                if ("adminStatus".equals(fieldName)) {
                    deserializedImportJobProperties.adminStatus = ImportJobAdminStatus.fromString(reader.getString());
                    continue;
                }
                if ("importPrefixes".equals(fieldName)) {
                    List importPrefixes;
                    deserializedImportJobProperties.importPrefixes = importPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("conflictResolutionMode".equals(fieldName)) {
                    deserializedImportJobProperties.conflictResolutionMode = ConflictResolutionMode.fromString(reader.getString());
                    continue;
                }
                if ("maximumErrors".equals(fieldName)) {
                    deserializedImportJobProperties.maximumErrors = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedImportJobProperties.innerStatus = ImportJobPropertiesStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportJobProperties;
        });
    }
}

