/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobProperties;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import com.azure.resourcemanager.storagecache.models.ImportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.ImportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.ImportStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ImportJobInner
extends Resource {
    private ImportJobProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ImportJobProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ImportJobInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ImportJobInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ImportJobProvisioningStateType provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ImportJobAdminStatus adminStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().adminStatus();
    }

    public ImportJobInner withAdminStatus(ImportJobAdminStatus adminStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportJobProperties();
        }
        this.innerProperties().withAdminStatus(adminStatus);
        return this;
    }

    public List<String> importPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().importPrefixes();
    }

    public ImportJobInner withImportPrefixes(List<String> importPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportJobProperties();
        }
        this.innerProperties().withImportPrefixes(importPrefixes);
        return this;
    }

    public ConflictResolutionMode conflictResolutionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().conflictResolutionMode();
    }

    public ImportJobInner withConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportJobProperties();
        }
        this.innerProperties().withConflictResolutionMode(conflictResolutionMode);
        return this;
    }

    public Integer maximumErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumErrors();
    }

    public ImportJobInner withMaximumErrors(Integer maximumErrors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportJobProperties();
        }
        this.innerProperties().withMaximumErrors(maximumErrors);
        return this;
    }

    public ImportStatusType state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String statusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().statusMessage();
    }

    public Long totalBlobsWalked() {
        return this.innerProperties() == null ? null : this.innerProperties().totalBlobsWalked();
    }

    public Long blobsWalkedPerSecond() {
        return this.innerProperties() == null ? null : this.innerProperties().blobsWalkedPerSecond();
    }

    public Long totalBlobsImported() {
        return this.innerProperties() == null ? null : this.innerProperties().totalBlobsImported();
    }

    public Long importedFiles() {
        return this.innerProperties() == null ? null : this.innerProperties().importedFiles();
    }

    public Long importedDirectories() {
        return this.innerProperties() == null ? null : this.innerProperties().importedDirectories();
    }

    public Long importedSymlinks() {
        return this.innerProperties() == null ? null : this.innerProperties().importedSymlinks();
    }

    public Long preexistingFiles() {
        return this.innerProperties() == null ? null : this.innerProperties().preexistingFiles();
    }

    public Long preexistingDirectories() {
        return this.innerProperties() == null ? null : this.innerProperties().preexistingDirectories();
    }

    public Long preexistingSymlinks() {
        return this.innerProperties() == null ? null : this.innerProperties().preexistingSymlinks();
    }

    public Long blobsImportedPerSecond() {
        return this.innerProperties() == null ? null : this.innerProperties().blobsImportedPerSecond();
    }

    public OffsetDateTime lastCompletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastCompletionTime();
    }

    public OffsetDateTime lastStartedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastStartedTime();
    }

    public Integer totalErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().totalErrors();
    }

    public Integer totalConflicts() {
        return this.innerProperties() == null ? null : this.innerProperties().totalConflicts();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ImportJobInner fromJson(JsonReader jsonReader) throws IOException {
        return (ImportJobInner)((Object)jsonReader.readObject(reader -> {
            ImportJobInner deserializedImportJobInner = new ImportJobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedImportJobInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedImportJobInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedImportJobInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedImportJobInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedImportJobInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedImportJobInner.innerProperties = ImportJobProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedImportJobInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportJobInner;
        }));
    }
}

