/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.CacheDirectorySettings;
import com.azure.resourcemanager.storagecache.models.CacheEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.CacheHealth;
import com.azure.resourcemanager.storagecache.models.CacheNetworkSettings;
import com.azure.resourcemanager.storagecache.models.CacheSecuritySettings;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeSettings;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeStatus;
import com.azure.resourcemanager.storagecache.models.PrimingJob;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTargetSpaceAllocation;
import java.io.IOException;
import java.util.List;

public final class CacheProperties
implements JsonSerializable<CacheProperties> {
    private Integer cacheSizeGB;
    private CacheHealth health;
    private List<String> mountAddresses;
    private ProvisioningStateType provisioningState;
    private String subnet;
    private CacheUpgradeStatus upgradeStatus;
    private CacheUpgradeSettings upgradeSettings;
    private CacheNetworkSettings networkSettings;
    private CacheEncryptionSettings encryptionSettings;
    private CacheSecuritySettings securitySettings;
    private CacheDirectorySettings directoryServicesSettings;
    private List<String> zones;
    private List<PrimingJob> primingJobs;
    private List<StorageTargetSpaceAllocation> spaceAllocation;

    public Integer cacheSizeGB() {
        return this.cacheSizeGB;
    }

    public CacheProperties withCacheSizeGB(Integer cacheSizeGB) {
        this.cacheSizeGB = cacheSizeGB;
        return this;
    }

    public CacheHealth health() {
        return this.health;
    }

    public List<String> mountAddresses() {
        return this.mountAddresses;
    }

    public ProvisioningStateType provisioningState() {
        return this.provisioningState;
    }

    public String subnet() {
        return this.subnet;
    }

    public CacheProperties withSubnet(String subnet) {
        this.subnet = subnet;
        return this;
    }

    public CacheUpgradeStatus upgradeStatus() {
        return this.upgradeStatus;
    }

    public CacheUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    public CacheProperties withUpgradeSettings(CacheUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    public CacheNetworkSettings networkSettings() {
        return this.networkSettings;
    }

    public CacheProperties withNetworkSettings(CacheNetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
        return this;
    }

    public CacheEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public CacheProperties withEncryptionSettings(CacheEncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public CacheSecuritySettings securitySettings() {
        return this.securitySettings;
    }

    public CacheProperties withSecuritySettings(CacheSecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    public CacheDirectorySettings directoryServicesSettings() {
        return this.directoryServicesSettings;
    }

    public CacheProperties withDirectoryServicesSettings(CacheDirectorySettings directoryServicesSettings) {
        this.directoryServicesSettings = directoryServicesSettings;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public CacheProperties withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public List<PrimingJob> primingJobs() {
        return this.primingJobs;
    }

    public List<StorageTargetSpaceAllocation> spaceAllocation() {
        return this.spaceAllocation;
    }

    public void validate() {
        if (this.health() != null) {
            this.health().validate();
        }
        if (this.upgradeStatus() != null) {
            this.upgradeStatus().validate();
        }
        if (this.upgradeSettings() != null) {
            this.upgradeSettings().validate();
        }
        if (this.networkSettings() != null) {
            this.networkSettings().validate();
        }
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().validate();
        }
        if (this.securitySettings() != null) {
            this.securitySettings().validate();
        }
        if (this.directoryServicesSettings() != null) {
            this.directoryServicesSettings().validate();
        }
        if (this.primingJobs() != null) {
            this.primingJobs().forEach(e -> e.validate());
        }
        if (this.spaceAllocation() != null) {
            this.spaceAllocation().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("cacheSizeGB", (Number)this.cacheSizeGB);
        jsonWriter.writeStringField("subnet", this.subnet);
        jsonWriter.writeJsonField("upgradeSettings", (JsonSerializable)this.upgradeSettings);
        jsonWriter.writeJsonField("networkSettings", (JsonSerializable)this.networkSettings);
        jsonWriter.writeJsonField("encryptionSettings", (JsonSerializable)this.encryptionSettings);
        jsonWriter.writeJsonField("securitySettings", (JsonSerializable)this.securitySettings);
        jsonWriter.writeJsonField("directoryServicesSettings", (JsonSerializable)this.directoryServicesSettings);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CacheProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CacheProperties)jsonReader.readObject(reader -> {
            CacheProperties deserializedCacheProperties = new CacheProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cacheSizeGB".equals(fieldName)) {
                    deserializedCacheProperties.cacheSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedCacheProperties.health = CacheHealth.fromJson(reader);
                    continue;
                }
                if ("mountAddresses".equals(fieldName)) {
                    List mountAddresses;
                    deserializedCacheProperties.mountAddresses = mountAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCacheProperties.provisioningState = ProvisioningStateType.fromString(reader.getString());
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedCacheProperties.subnet = reader.getString();
                    continue;
                }
                if ("upgradeStatus".equals(fieldName)) {
                    deserializedCacheProperties.upgradeStatus = CacheUpgradeStatus.fromJson(reader);
                    continue;
                }
                if ("upgradeSettings".equals(fieldName)) {
                    deserializedCacheProperties.upgradeSettings = CacheUpgradeSettings.fromJson(reader);
                    continue;
                }
                if ("networkSettings".equals(fieldName)) {
                    deserializedCacheProperties.networkSettings = CacheNetworkSettings.fromJson(reader);
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    deserializedCacheProperties.encryptionSettings = CacheEncryptionSettings.fromJson(reader);
                    continue;
                }
                if ("securitySettings".equals(fieldName)) {
                    deserializedCacheProperties.securitySettings = CacheSecuritySettings.fromJson(reader);
                    continue;
                }
                if ("directoryServicesSettings".equals(fieldName)) {
                    deserializedCacheProperties.directoryServicesSettings = CacheDirectorySettings.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedCacheProperties.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("primingJobs".equals(fieldName)) {
                    List primingJobs;
                    deserializedCacheProperties.primingJobs = primingJobs = reader.readArray(reader1 -> PrimingJob.fromJson(reader1));
                    continue;
                }
                if ("spaceAllocation".equals(fieldName)) {
                    List spaceAllocation;
                    deserializedCacheProperties.spaceAllocation = spaceAllocation = reader.readArray(reader1 -> StorageTargetSpaceAllocation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheProperties;
        });
    }
}

