/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ApiOperationProperties;
import com.azure.resourcemanager.storagecache.models.ApiOperationDisplay;
import com.azure.resourcemanager.storagecache.models.ApiOperationPropertiesServiceSpecification;
import java.io.IOException;

public final class ApiOperationInner
implements JsonSerializable<ApiOperationInner> {
    private ApiOperationDisplay display;
    private String origin;
    private Boolean isDataAction;
    private String name;
    private ApiOperationProperties innerProperties;

    public ApiOperationDisplay display() {
        return this.display;
    }

    public ApiOperationInner withDisplay(ApiOperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public ApiOperationInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public ApiOperationInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ApiOperationInner withName(String name) {
        this.name = name;
        return this;
    }

    private ApiOperationProperties innerProperties() {
        return this.innerProperties;
    }

    public ApiOperationPropertiesServiceSpecification serviceSpecification() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceSpecification();
    }

    public ApiOperationInner withServiceSpecification(ApiOperationPropertiesServiceSpecification serviceSpecification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiOperationProperties();
        }
        this.innerProperties().withServiceSpecification(serviceSpecification);
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ApiOperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApiOperationInner)jsonReader.readObject(reader -> {
            ApiOperationInner deserializedApiOperationInner = new ApiOperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("display".equals(fieldName)) {
                    deserializedApiOperationInner.display = ApiOperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedApiOperationInner.origin = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedApiOperationInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiOperationInner.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApiOperationInner.innerProperties = ApiOperationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiOperationInner;
        });
    }
}

