/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemRootSquashSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemUpdatePropertiesMaintenanceWindow;
import java.io.IOException;

public final class AmlFilesystemUpdateProperties
implements JsonSerializable<AmlFilesystemUpdateProperties> {
    private AmlFilesystemEncryptionSettings encryptionSettings;
    private AmlFilesystemUpdatePropertiesMaintenanceWindow maintenanceWindow;
    private AmlFilesystemRootSquashSettings rootSquashSettings;

    public AmlFilesystemEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public AmlFilesystemUpdateProperties withEncryptionSettings(AmlFilesystemEncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public AmlFilesystemUpdatePropertiesMaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public AmlFilesystemUpdateProperties withMaintenanceWindow(AmlFilesystemUpdatePropertiesMaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public AmlFilesystemRootSquashSettings rootSquashSettings() {
        return this.rootSquashSettings;
    }

    public AmlFilesystemUpdateProperties withRootSquashSettings(AmlFilesystemRootSquashSettings rootSquashSettings) {
        this.rootSquashSettings = rootSquashSettings;
        return this;
    }

    public void validate() {
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().validate();
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
        if (this.rootSquashSettings() != null) {
            this.rootSquashSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryptionSettings", (JsonSerializable)this.encryptionSettings);
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        jsonWriter.writeJsonField("rootSquashSettings", (JsonSerializable)this.rootSquashSettings);
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemUpdateProperties)jsonReader.readObject(reader -> {
            AmlFilesystemUpdateProperties deserializedAmlFilesystemUpdateProperties = new AmlFilesystemUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encryptionSettings".equals(fieldName)) {
                    deserializedAmlFilesystemUpdateProperties.encryptionSettings = AmlFilesystemEncryptionSettings.fromJson(reader);
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedAmlFilesystemUpdateProperties.maintenanceWindow = AmlFilesystemUpdatePropertiesMaintenanceWindow.fromJson(reader);
                    continue;
                }
                if ("rootSquashSettings".equals(fieldName)) {
                    deserializedAmlFilesystemUpdateProperties.rootSquashSettings = AmlFilesystemRootSquashSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemUpdateProperties;
        });
    }
}

