/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.fluent.StorageCacheManagementClient;
import com.azure.resourcemanager.storagecache.implementation.AmlFilesystemsImpl;
import com.azure.resourcemanager.storagecache.implementation.AscOperationsImpl;
import com.azure.resourcemanager.storagecache.implementation.AscUsagesImpl;
import com.azure.resourcemanager.storagecache.implementation.AutoExportJobsImpl;
import com.azure.resourcemanager.storagecache.implementation.AutoImportJobsImpl;
import com.azure.resourcemanager.storagecache.implementation.CachesImpl;
import com.azure.resourcemanager.storagecache.implementation.ImportJobsImpl;
import com.azure.resourcemanager.storagecache.implementation.OperationsImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.storagecache.implementation.SkusImpl;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientBuilder;
import com.azure.resourcemanager.storagecache.implementation.StorageTargetOperationsImpl;
import com.azure.resourcemanager.storagecache.implementation.StorageTargetsImpl;
import com.azure.resourcemanager.storagecache.implementation.UsageModelsImpl;
import com.azure.resourcemanager.storagecache.models.AmlFilesystems;
import com.azure.resourcemanager.storagecache.models.AscOperations;
import com.azure.resourcemanager.storagecache.models.AscUsages;
import com.azure.resourcemanager.storagecache.models.AutoExportJobs;
import com.azure.resourcemanager.storagecache.models.AutoImportJobs;
import com.azure.resourcemanager.storagecache.models.Caches;
import com.azure.resourcemanager.storagecache.models.ImportJobs;
import com.azure.resourcemanager.storagecache.models.Operations;
import com.azure.resourcemanager.storagecache.models.ResourceProviders;
import com.azure.resourcemanager.storagecache.models.Skus;
import com.azure.resourcemanager.storagecache.models.StorageTargetOperations;
import com.azure.resourcemanager.storagecache.models.StorageTargets;
import com.azure.resourcemanager.storagecache.models.UsageModels;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class StorageCacheManager {
    private AmlFilesystems amlFilesystems;
    private AutoExportJobs autoExportJobs;
    private ImportJobs importJobs;
    private AutoImportJobs autoImportJobs;
    private ResourceProviders resourceProviders;
    private Operations operations;
    private Skus skus;
    private UsageModels usageModels;
    private AscOperations ascOperations;
    private AscUsages ascUsages;
    private Caches caches;
    private StorageTargets storageTargets;
    private StorageTargetOperations storageTargetOperations;
    private final StorageCacheManagementClient clientObject;

    private StorageCacheManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new StorageCacheManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static StorageCacheManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return StorageCacheManager.configure().authenticate(credential, profile);
    }

    public static StorageCacheManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new StorageCacheManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public AmlFilesystems amlFilesystems() {
        if (this.amlFilesystems == null) {
            this.amlFilesystems = new AmlFilesystemsImpl(this.clientObject.getAmlFilesystems(), this);
        }
        return this.amlFilesystems;
    }

    public AutoExportJobs autoExportJobs() {
        if (this.autoExportJobs == null) {
            this.autoExportJobs = new AutoExportJobsImpl(this.clientObject.getAutoExportJobs(), this);
        }
        return this.autoExportJobs;
    }

    public ImportJobs importJobs() {
        if (this.importJobs == null) {
            this.importJobs = new ImportJobsImpl(this.clientObject.getImportJobs(), this);
        }
        return this.importJobs;
    }

    public AutoImportJobs autoImportJobs() {
        if (this.autoImportJobs == null) {
            this.autoImportJobs = new AutoImportJobsImpl(this.clientObject.getAutoImportJobs(), this);
        }
        return this.autoImportJobs;
    }

    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(this.clientObject.getResourceProviders(), this);
        }
        return this.resourceProviders;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Skus skus() {
        if (this.skus == null) {
            this.skus = new SkusImpl(this.clientObject.getSkus(), this);
        }
        return this.skus;
    }

    public UsageModels usageModels() {
        if (this.usageModels == null) {
            this.usageModels = new UsageModelsImpl(this.clientObject.getUsageModels(), this);
        }
        return this.usageModels;
    }

    public AscOperations ascOperations() {
        if (this.ascOperations == null) {
            this.ascOperations = new AscOperationsImpl(this.clientObject.getAscOperations(), this);
        }
        return this.ascOperations;
    }

    public AscUsages ascUsages() {
        if (this.ascUsages == null) {
            this.ascUsages = new AscUsagesImpl(this.clientObject.getAscUsages(), this);
        }
        return this.ascUsages;
    }

    public Caches caches() {
        if (this.caches == null) {
            this.caches = new CachesImpl(this.clientObject.getCaches(), this);
        }
        return this.caches;
    }

    public StorageTargets storageTargets() {
        if (this.storageTargets == null) {
            this.storageTargets = new StorageTargetsImpl(this.clientObject.getStorageTargets(), this);
        }
        return this.storageTargets;
    }

    public StorageTargetOperations storageTargetOperations() {
        if (this.storageTargetOperations == null) {
            this.storageTargetOperations = new StorageTargetOperationsImpl(this.clientObject.getStorageTargetOperations(), this);
        }
        return this.storageTargetOperations;
    }

    public StorageCacheManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-storagecache.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public StorageCacheManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.storagecache").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new StorageCacheManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

