/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.ProvisioningState;
import com.azure.resourcemanager.storageactions.models.StorageTaskAction;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class StorageTaskUpdateProperties
implements JsonSerializable<StorageTaskUpdateProperties> {
    private Long taskVersion;
    private Boolean enabled;
    private String description;
    private StorageTaskAction action;
    private ProvisioningState provisioningState;
    private OffsetDateTime creationTimeInUtc;

    public Long taskVersion() {
        return this.taskVersion;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public StorageTaskUpdateProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String description() {
        return this.description;
    }

    public StorageTaskUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public StorageTaskAction action() {
        return this.action;
    }

    public StorageTaskUpdateProperties withAction(StorageTaskAction action) {
        this.action = action;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime creationTimeInUtc() {
        return this.creationTimeInUtc;
    }

    public void validate() {
        if (this.action() != null) {
            this.action().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskUpdateProperties)jsonReader.readObject(reader -> {
            StorageTaskUpdateProperties deserializedStorageTaskUpdateProperties = new StorageTaskUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskVersion".equals(fieldName)) {
                    deserializedStorageTaskUpdateProperties.taskVersion = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedStorageTaskUpdateProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedStorageTaskUpdateProperties.description = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedStorageTaskUpdateProperties.action = StorageTaskAction.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageTaskUpdateProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("creationTimeInUtc".equals(fieldName)) {
                    deserializedStorageTaskUpdateProperties.creationTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskUpdateProperties;
        });
    }
}

