/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.ProvisioningState;
import com.azure.resourcemanager.storageactions.models.StorageTaskAction;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class StorageTaskProperties
implements JsonSerializable<StorageTaskProperties> {
    private Long taskVersion;
    private boolean enabled;
    private String description;
    private StorageTaskAction action;
    private ProvisioningState provisioningState;
    private OffsetDateTime creationTimeInUtc;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskProperties.class);

    public Long taskVersion() {
        return this.taskVersion;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public StorageTaskProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String description() {
        return this.description;
    }

    public StorageTaskProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public StorageTaskAction action() {
        return this.action;
    }

    public StorageTaskProperties withAction(StorageTaskAction action) {
        this.action = action;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime creationTimeInUtc() {
        return this.creationTimeInUtc;
    }

    public void validate() {
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model StorageTaskProperties"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model StorageTaskProperties"));
        }
        this.action().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskProperties)jsonReader.readObject(reader -> {
            StorageTaskProperties deserializedStorageTaskProperties = new StorageTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedStorageTaskProperties.enabled = reader.getBoolean();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedStorageTaskProperties.description = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedStorageTaskProperties.action = StorageTaskAction.fromJson(reader);
                    continue;
                }
                if ("taskVersion".equals(fieldName)) {
                    deserializedStorageTaskProperties.taskVersion = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageTaskProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("creationTimeInUtc".equals(fieldName)) {
                    deserializedStorageTaskProperties.creationTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskProperties;
        });
    }
}

