/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.StorageTaskPreviewKeyValueProperties;
import java.io.IOException;
import java.util.List;

public final class StorageTaskPreviewContainerProperties
implements JsonSerializable<StorageTaskPreviewContainerProperties> {
    private String name;
    private List<StorageTaskPreviewKeyValueProperties> metadata;

    public String name() {
        return this.name;
    }

    public StorageTaskPreviewContainerProperties withName(String name) {
        this.name = name;
        return this;
    }

    public List<StorageTaskPreviewKeyValueProperties> metadata() {
        return this.metadata;
    }

    public StorageTaskPreviewContainerProperties withMetadata(List<StorageTaskPreviewKeyValueProperties> metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskPreviewContainerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskPreviewContainerProperties)jsonReader.readObject(reader -> {
            StorageTaskPreviewContainerProperties deserializedStorageTaskPreviewContainerProperties = new StorageTaskPreviewContainerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStorageTaskPreviewContainerProperties.name = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedStorageTaskPreviewContainerProperties.metadata = metadata = reader.readArray(reader1 -> StorageTaskPreviewKeyValueProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskPreviewContainerProperties;
        });
    }
}

