/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.ElseCondition;
import com.azure.resourcemanager.storageactions.models.IfCondition;
import java.io.IOException;

public final class StorageTaskAction
implements JsonSerializable<StorageTaskAction> {
    private IfCondition ifProperty;
    private ElseCondition elseProperty;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAction.class);

    public IfCondition ifProperty() {
        return this.ifProperty;
    }

    public StorageTaskAction withIfProperty(IfCondition ifProperty) {
        this.ifProperty = ifProperty;
        return this;
    }

    public ElseCondition elseProperty() {
        return this.elseProperty;
    }

    public StorageTaskAction withElseProperty(ElseCondition elseProperty) {
        this.elseProperty = elseProperty;
        return this;
    }

    public void validate() {
        if (this.ifProperty() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ifProperty in model StorageTaskAction"));
        }
        this.ifProperty().validate();
        if (this.elseProperty() != null) {
            this.elseProperty().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("if", (JsonSerializable)this.ifProperty);
        jsonWriter.writeJsonField("else", (JsonSerializable)this.elseProperty);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskAction fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskAction)jsonReader.readObject(reader -> {
            StorageTaskAction deserializedStorageTaskAction = new StorageTaskAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("if".equals(fieldName)) {
                    deserializedStorageTaskAction.ifProperty = IfCondition.fromJson(reader);
                    continue;
                }
                if ("else".equals(fieldName)) {
                    deserializedStorageTaskAction.elseProperty = ElseCondition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskAction;
        });
    }
}

