/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.StorageTaskOperation;
import java.io.IOException;
import java.util.List;

public final class IfCondition
implements JsonSerializable<IfCondition> {
    private String condition;
    private List<StorageTaskOperation> operations;
    private static final ClientLogger LOGGER = new ClientLogger(IfCondition.class);

    public String condition() {
        return this.condition;
    }

    public IfCondition withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public List<StorageTaskOperation> operations() {
        return this.operations;
    }

    public IfCondition withOperations(List<StorageTaskOperation> operations) {
        this.operations = operations;
        return this;
    }

    public void validate() {
        if (this.condition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property condition in model IfCondition"));
        }
        if (this.operations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operations in model IfCondition"));
        }
        this.operations().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IfCondition fromJson(JsonReader jsonReader) throws IOException {
        return (IfCondition)jsonReader.readObject(reader -> {
            IfCondition deserializedIfCondition = new IfCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("condition".equals(fieldName)) {
                    deserializedIfCondition.condition = reader.getString();
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedIfCondition.operations = operations = reader.readArray(reader1 -> StorageTaskOperation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIfCondition;
        });
    }
}

