/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storageactions.StorageActionsManager;
import com.azure.resourcemanager.storageactions.fluent.StorageTasksClient;
import com.azure.resourcemanager.storageactions.fluent.models.StorageTaskInner;
import com.azure.resourcemanager.storageactions.fluent.models.StorageTaskPreviewActionInner;
import com.azure.resourcemanager.storageactions.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storageactions.implementation.StorageTaskImpl;
import com.azure.resourcemanager.storageactions.implementation.StorageTaskPreviewActionImpl;
import com.azure.resourcemanager.storageactions.models.StorageTask;
import com.azure.resourcemanager.storageactions.models.StorageTaskPreviewAction;
import com.azure.resourcemanager.storageactions.models.StorageTasks;

public final class StorageTasksImpl
implements StorageTasks {
    private static final ClientLogger LOGGER = new ClientLogger(StorageTasksImpl.class);
    private final StorageTasksClient innerClient;
    private final StorageActionsManager serviceManager;

    public StorageTasksImpl(StorageTasksClient innerClient, StorageActionsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<StorageTask> getByResourceGroupWithResponse(String resourceGroupName, String storageTaskName, Context context) {
        Response<StorageTaskInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, storageTaskName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StorageTaskImpl((StorageTaskInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public StorageTask getByResourceGroup(String resourceGroupName, String storageTaskName) {
        StorageTaskInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, storageTaskName);
        if (inner != null) {
            return new StorageTaskImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String storageTaskName) {
        this.serviceClient().delete(resourceGroupName, storageTaskName);
    }

    @Override
    public void delete(String resourceGroupName, String storageTaskName, Context context) {
        this.serviceClient().delete(resourceGroupName, storageTaskName, context);
    }

    @Override
    public PagedIterable<StorageTask> listByResourceGroup(String resourceGroupName) {
        PagedIterable<StorageTaskInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskImpl((StorageTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageTask> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<StorageTaskInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskImpl((StorageTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageTask> list() {
        PagedIterable<StorageTaskInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskImpl((StorageTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageTask> list(Context context) {
        PagedIterable<StorageTaskInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskImpl((StorageTaskInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<StorageTaskPreviewAction> previewActionsWithResponse(String location, StorageTaskPreviewActionInner parameters, Context context) {
        Response<StorageTaskPreviewActionInner> inner = this.serviceClient().previewActionsWithResponse(location, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StorageTaskPreviewActionImpl((StorageTaskPreviewActionInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public StorageTaskPreviewAction previewActions(String location, StorageTaskPreviewActionInner parameters) {
        StorageTaskPreviewActionInner inner = this.serviceClient().previewActions(location, parameters);
        if (inner != null) {
            return new StorageTaskPreviewActionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public StorageTask getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageTaskName = ResourceManagerUtils.getValueFromIdByName(id, "storageTasks");
        if (storageTaskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTasks'.", id)));
        }
        return (StorageTask)this.getByResourceGroupWithResponse(resourceGroupName, storageTaskName, Context.NONE).getValue();
    }

    @Override
    public Response<StorageTask> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageTaskName = ResourceManagerUtils.getValueFromIdByName(id, "storageTasks");
        if (storageTaskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTasks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, storageTaskName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageTaskName = ResourceManagerUtils.getValueFromIdByName(id, "storageTasks");
        if (storageTaskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTasks'.", id)));
        }
        this.delete(resourceGroupName, storageTaskName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageTaskName = ResourceManagerUtils.getValueFromIdByName(id, "storageTasks");
        if (storageTaskName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageTasks'.", id)));
        }
        this.delete(resourceGroupName, storageTaskName, context);
    }

    private StorageTasksClient serviceClient() {
        return this.innerClient;
    }

    private StorageActionsManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageTaskImpl define(String name) {
        return new StorageTaskImpl(name, this.manager());
    }
}

