/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.MatchedBlockName;
import com.azure.resourcemanager.storageactions.models.StorageTaskPreviewKeyValueProperties;
import java.io.IOException;
import java.util.List;

public final class StorageTaskPreviewBlobProperties
implements JsonSerializable<StorageTaskPreviewBlobProperties> {
    private String name;
    private List<StorageTaskPreviewKeyValueProperties> properties;
    private List<StorageTaskPreviewKeyValueProperties> metadata;
    private List<StorageTaskPreviewKeyValueProperties> tags;
    private MatchedBlockName matchedBlock;

    public String name() {
        return this.name;
    }

    public StorageTaskPreviewBlobProperties withName(String name) {
        this.name = name;
        return this;
    }

    public List<StorageTaskPreviewKeyValueProperties> properties() {
        return this.properties;
    }

    public StorageTaskPreviewBlobProperties withProperties(List<StorageTaskPreviewKeyValueProperties> properties) {
        this.properties = properties;
        return this;
    }

    public List<StorageTaskPreviewKeyValueProperties> metadata() {
        return this.metadata;
    }

    public StorageTaskPreviewBlobProperties withMetadata(List<StorageTaskPreviewKeyValueProperties> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<StorageTaskPreviewKeyValueProperties> tags() {
        return this.tags;
    }

    public StorageTaskPreviewBlobProperties withTags(List<StorageTaskPreviewKeyValueProperties> tags) {
        this.tags = tags;
        return this;
    }

    public MatchedBlockName matchedBlock() {
        return this.matchedBlock;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().forEach(e -> e.validate());
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
        if (this.tags() != null) {
            this.tags().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("properties", this.properties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskPreviewBlobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskPreviewBlobProperties)jsonReader.readObject(reader -> {
            StorageTaskPreviewBlobProperties deserializedStorageTaskPreviewBlobProperties = new StorageTaskPreviewBlobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStorageTaskPreviewBlobProperties.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    List properties;
                    deserializedStorageTaskPreviewBlobProperties.properties = properties = reader.readArray(reader1 -> StorageTaskPreviewKeyValueProperties.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedStorageTaskPreviewBlobProperties.metadata = metadata = reader.readArray(reader1 -> StorageTaskPreviewKeyValueProperties.fromJson(reader1));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tags;
                    deserializedStorageTaskPreviewBlobProperties.tags = tags = reader.readArray(reader1 -> StorageTaskPreviewKeyValueProperties.fromJson(reader1));
                    continue;
                }
                if ("matchedBlock".equals(fieldName)) {
                    deserializedStorageTaskPreviewBlobProperties.matchedBlock = MatchedBlockName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskPreviewBlobProperties;
        });
    }
}

