/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.StorageTaskPreviewActionCondition;
import com.azure.resourcemanager.storageactions.models.StorageTaskPreviewBlobProperties;
import com.azure.resourcemanager.storageactions.models.StorageTaskPreviewContainerProperties;
import java.io.IOException;
import java.util.List;

public final class StorageTaskPreviewActionProperties
implements JsonSerializable<StorageTaskPreviewActionProperties> {
    private StorageTaskPreviewContainerProperties container;
    private List<StorageTaskPreviewBlobProperties> blobs;
    private StorageTaskPreviewActionCondition action;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskPreviewActionProperties.class);

    public StorageTaskPreviewContainerProperties container() {
        return this.container;
    }

    public StorageTaskPreviewActionProperties withContainer(StorageTaskPreviewContainerProperties container) {
        this.container = container;
        return this;
    }

    public List<StorageTaskPreviewBlobProperties> blobs() {
        return this.blobs;
    }

    public StorageTaskPreviewActionProperties withBlobs(List<StorageTaskPreviewBlobProperties> blobs) {
        this.blobs = blobs;
        return this;
    }

    public StorageTaskPreviewActionCondition action() {
        return this.action;
    }

    public StorageTaskPreviewActionProperties withAction(StorageTaskPreviewActionCondition action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.container() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property container in model StorageTaskPreviewActionProperties"));
        }
        this.container().validate();
        if (this.blobs() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property blobs in model StorageTaskPreviewActionProperties"));
        }
        this.blobs().forEach(e -> e.validate());
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model StorageTaskPreviewActionProperties"));
        }
        this.action().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("container", (JsonSerializable)this.container);
        jsonWriter.writeArrayField("blobs", this.blobs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskPreviewActionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskPreviewActionProperties)jsonReader.readObject(reader -> {
            StorageTaskPreviewActionProperties deserializedStorageTaskPreviewActionProperties = new StorageTaskPreviewActionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("container".equals(fieldName)) {
                    deserializedStorageTaskPreviewActionProperties.container = StorageTaskPreviewContainerProperties.fromJson(reader);
                    continue;
                }
                if ("blobs".equals(fieldName)) {
                    List blobs;
                    deserializedStorageTaskPreviewActionProperties.blobs = blobs = reader.readArray(reader1 -> StorageTaskPreviewBlobProperties.fromJson(reader1));
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedStorageTaskPreviewActionProperties.action = StorageTaskPreviewActionCondition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskPreviewActionProperties;
        });
    }
}

