/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.OnFailure;
import com.azure.resourcemanager.storageactions.models.OnSuccess;
import com.azure.resourcemanager.storageactions.models.StorageTaskOperationName;
import java.io.IOException;
import java.util.Map;

public final class StorageTaskOperation
implements JsonSerializable<StorageTaskOperation> {
    private StorageTaskOperationName name;
    private Map<String, String> parameters;
    private OnSuccess onSuccess;
    private OnFailure onFailure;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskOperation.class);

    public StorageTaskOperationName name() {
        return this.name;
    }

    public StorageTaskOperation withName(StorageTaskOperationName name) {
        this.name = name;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public StorageTaskOperation withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public OnSuccess onSuccess() {
        return this.onSuccess;
    }

    public StorageTaskOperation withOnSuccess(OnSuccess onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public OnFailure onFailure() {
        return this.onFailure;
    }

    public StorageTaskOperation withOnFailure(OnFailure onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model StorageTaskOperation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("onSuccess", this.onSuccess == null ? null : this.onSuccess.toString());
        jsonWriter.writeStringField("onFailure", this.onFailure == null ? null : this.onFailure.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskOperation fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskOperation)jsonReader.readObject(reader -> {
            StorageTaskOperation deserializedStorageTaskOperation = new StorageTaskOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStorageTaskOperation.name = StorageTaskOperationName.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedStorageTaskOperation.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("onSuccess".equals(fieldName)) {
                    deserializedStorageTaskOperation.onSuccess = OnSuccess.fromString(reader.getString());
                    continue;
                }
                if ("onFailure".equals(fieldName)) {
                    deserializedStorageTaskOperation.onFailure = OnFailure.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskOperation;
        });
    }
}

