/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storageactions.fluent.models.StorageTaskInner;
import com.azure.resourcemanager.storageactions.models.ManagedServiceIdentity;
import com.azure.resourcemanager.storageactions.models.StorageTaskProperties;
import java.util.Map;

public interface StorageTask {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ManagedServiceIdentity identity();

    public StorageTaskProperties properties();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public StorageTaskInner innerModel();

    public Update update();

    public StorageTask refresh();

    public StorageTask refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(StorageTaskProperties var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithProperties {
        public StorageTask apply();

        public StorageTask apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags {
            public StorageTask create();

            public StorageTask create(Context var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(StorageTaskProperties var1);
        }

        public static interface WithIdentity {
            public WithProperties withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithResourceGroup {
            public WithIdentity withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithIdentity,
    DefinitionStages.WithProperties,
    DefinitionStages.WithCreate {
    }
}

