/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.StorageTaskOperation;
import java.io.IOException;
import java.util.List;

public final class ElseCondition
implements JsonSerializable<ElseCondition> {
    private List<StorageTaskOperation> operations;
    private static final ClientLogger LOGGER = new ClientLogger(ElseCondition.class);

    public List<StorageTaskOperation> operations() {
        return this.operations;
    }

    public ElseCondition withOperations(List<StorageTaskOperation> operations) {
        this.operations = operations;
        return this;
    }

    public void validate() {
        if (this.operations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operations in model ElseCondition"));
        }
        this.operations().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ElseCondition fromJson(JsonReader jsonReader) throws IOException {
        return (ElseCondition)jsonReader.readObject(reader -> {
            ElseCondition deserializedElseCondition = new ElseCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedElseCondition.operations = operations = reader.readArray(reader1 -> StorageTaskOperation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElseCondition;
        });
    }
}

