/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storageactions.StorageActionsManager;
import com.azure.resourcemanager.storageactions.fluent.StorageTasksReportsClient;
import com.azure.resourcemanager.storageactions.fluent.models.StorageTaskReportInstanceInner;
import com.azure.resourcemanager.storageactions.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storageactions.implementation.StorageTaskReportInstanceImpl;
import com.azure.resourcemanager.storageactions.models.StorageTaskReportInstance;
import com.azure.resourcemanager.storageactions.models.StorageTasksReports;

public final class StorageTasksReportsImpl
implements StorageTasksReports {
    private static final ClientLogger LOGGER = new ClientLogger(StorageTasksReportsImpl.class);
    private final StorageTasksReportsClient innerClient;
    private final StorageActionsManager serviceManager;

    public StorageTasksReportsImpl(StorageTasksReportsClient innerClient, StorageActionsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<StorageTaskReportInstance> list(String resourceGroupName, String storageTaskName) {
        PagedIterable<StorageTaskReportInstanceInner> inner = this.serviceClient().list(resourceGroupName, storageTaskName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskReportInstanceImpl((StorageTaskReportInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageTaskReportInstance> list(String resourceGroupName, String storageTaskName, Integer maxpagesize, String filter, Context context) {
        PagedIterable<StorageTaskReportInstanceInner> inner = this.serviceClient().list(resourceGroupName, storageTaskName, maxpagesize, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskReportInstanceImpl((StorageTaskReportInstanceInner)((Object)inner1), this.manager()));
    }

    private StorageTasksReportsClient serviceClient() {
        return this.innerClient;
    }

    private StorageActionsManager manager() {
        return this.serviceManager;
    }
}

