/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storageactions.StorageActionsManager;
import com.azure.resourcemanager.storageactions.fluent.models.StorageTaskInner;
import com.azure.resourcemanager.storageactions.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storageactions.models.ManagedServiceIdentity;
import com.azure.resourcemanager.storageactions.models.StorageTask;
import com.azure.resourcemanager.storageactions.models.StorageTaskProperties;
import com.azure.resourcemanager.storageactions.models.StorageTaskUpdateParameters;
import java.util.Collections;
import java.util.Map;

public final class StorageTaskImpl
implements StorageTask,
StorageTask.Definition,
StorageTask.Update {
    private StorageTaskInner innerObject;
    private final StorageActionsManager serviceManager;
    private String resourceGroupName;
    private String storageTaskName;
    private StorageTaskUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public StorageTaskProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public StorageTaskInner innerModel() {
        return this.innerObject;
    }

    private StorageActionsManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageTaskImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public StorageTask create() {
        this.innerObject = this.serviceManager.serviceClient().getStorageTasks().create(this.resourceGroupName, this.storageTaskName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public StorageTask create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageTasks().create(this.resourceGroupName, this.storageTaskName, this.innerModel(), context);
        return this;
    }

    StorageTaskImpl(String name, StorageActionsManager serviceManager) {
        this.innerObject = new StorageTaskInner();
        this.serviceManager = serviceManager;
        this.storageTaskName = name;
    }

    @Override
    public StorageTaskImpl update() {
        this.updateParameters = new StorageTaskUpdateParameters();
        return this;
    }

    @Override
    public StorageTask apply() {
        this.innerObject = this.serviceManager.serviceClient().getStorageTasks().update(this.resourceGroupName, this.storageTaskName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public StorageTask apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getStorageTasks().update(this.resourceGroupName, this.storageTaskName, this.updateParameters, context);
        return this;
    }

    StorageTaskImpl(StorageTaskInner innerObject, StorageActionsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.storageTaskName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storageTasks");
    }

    @Override
    public StorageTask refresh() {
        this.innerObject = (StorageTaskInner)((Object)this.serviceManager.serviceClient().getStorageTasks().getByResourceGroupWithResponse(this.resourceGroupName, this.storageTaskName, Context.NONE).getValue());
        return this;
    }

    @Override
    public StorageTask refresh(Context context) {
        this.innerObject = (StorageTaskInner)((Object)this.serviceManager.serviceClient().getStorageTasks().getByResourceGroupWithResponse(this.resourceGroupName, this.storageTaskName, context).getValue());
        return this;
    }

    @Override
    public StorageTaskImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public StorageTaskImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public StorageTaskImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public StorageTaskImpl withProperties(StorageTaskProperties properties) {
        if (this.isInCreateMode()) {
            this.innerModel().withProperties(properties);
            return this;
        }
        this.updateParameters.withProperties(properties);
        return this;
    }

    @Override
    public StorageTaskImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

