/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storageactions.StorageActionsManager;
import com.azure.resourcemanager.storageactions.fluent.StorageTaskAssignmentsClient;
import com.azure.resourcemanager.storageactions.fluent.models.StorageTaskAssignmentInner;
import com.azure.resourcemanager.storageactions.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storageactions.implementation.StorageTaskAssignmentImpl;
import com.azure.resourcemanager.storageactions.models.StorageTaskAssignment;
import com.azure.resourcemanager.storageactions.models.StorageTaskAssignments;

public final class StorageTaskAssignmentsImpl
implements StorageTaskAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentsImpl.class);
    private final StorageTaskAssignmentsClient innerClient;
    private final StorageActionsManager serviceManager;

    public StorageTaskAssignmentsImpl(StorageTaskAssignmentsClient innerClient, StorageActionsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<StorageTaskAssignment> list(String resourceGroupName, String storageTaskName) {
        PagedIterable<StorageTaskAssignmentInner> inner = this.serviceClient().list(resourceGroupName, storageTaskName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskAssignmentImpl((StorageTaskAssignmentInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<StorageTaskAssignment> list(String resourceGroupName, String storageTaskName, Integer maxpagesize, Context context) {
        PagedIterable<StorageTaskAssignmentInner> inner = this.serviceClient().list(resourceGroupName, storageTaskName, maxpagesize, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageTaskAssignmentImpl((StorageTaskAssignmentInner)inner1, this.manager()));
    }

    private StorageTaskAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private StorageActionsManager manager() {
        return this.serviceManager;
    }
}

