/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storageactions.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storageactions.models.ManagedServiceIdentity;
import com.azure.resourcemanager.storageactions.models.StorageTaskProperties;
import java.io.IOException;
import java.util.Map;

public final class StorageTaskInner
extends Resource {
    private ManagedServiceIdentity identity;
    private StorageTaskProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskInner.class);

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public StorageTaskInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public StorageTaskProperties properties() {
        return this.properties;
    }

    public StorageTaskInner withProperties(StorageTaskProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public StorageTaskInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public StorageTaskInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.identity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property identity in model StorageTaskInner"));
        }
        this.identity().validate();
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model StorageTaskInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskInner fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskInner)((Object)jsonReader.readObject(reader -> {
            StorageTaskInner deserializedStorageTaskInner = new StorageTaskInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageTaskInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageTaskInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageTaskInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedStorageTaskInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedStorageTaskInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedStorageTaskInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageTaskInner.properties = StorageTaskProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedStorageTaskInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskInner;
        }));
    }
}

