/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.KeyPermission;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class StorageAccountKey
implements JsonSerializable<StorageAccountKey> {
    private String keyName;
    private String value;
    private KeyPermission permissions;
    private OffsetDateTime creationTime;

    public String keyName() {
        return this.keyName;
    }

    public String value() {
        return this.value;
    }

    public KeyPermission permissions() {
        return this.permissions;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountKey)jsonReader.readObject(reader -> {
            StorageAccountKey deserializedStorageAccountKey = new StorageAccountKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyName".equals(fieldName)) {
                    deserializedStorageAccountKey.keyName = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedStorageAccountKey.value = reader.getString();
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    deserializedStorageAccountKey.permissions = KeyPermission.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedStorageAccountKey.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountKey;
        });
    }
}

