/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.ObjectReplicationPolicyProperties;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyPropertiesMetrics;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyPropertiesPriorityReplication;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyRule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ObjectReplicationPolicyInner
extends ProxyResource {
    private ObjectReplicationPolicyProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ObjectReplicationPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String policyId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyId();
    }

    public OffsetDateTime enabledTime() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledTime();
    }

    public String sourceAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceAccount();
    }

    public ObjectReplicationPolicyInner withSourceAccount(String sourceAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withSourceAccount(sourceAccount);
        return this;
    }

    public String destinationAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationAccount();
    }

    public ObjectReplicationPolicyInner withDestinationAccount(String destinationAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withDestinationAccount(destinationAccount);
        return this;
    }

    public List<ObjectReplicationPolicyRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public ObjectReplicationPolicyInner withRules(List<ObjectReplicationPolicyRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public ObjectReplicationPolicyPropertiesMetrics metrics() {
        return this.innerProperties() == null ? null : this.innerProperties().metrics();
    }

    public ObjectReplicationPolicyInner withMetrics(ObjectReplicationPolicyPropertiesMetrics metrics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withMetrics(metrics);
        return this;
    }

    public ObjectReplicationPolicyPropertiesPriorityReplication priorityReplication() {
        return this.innerProperties() == null ? null : this.innerProperties().priorityReplication();
    }

    public ObjectReplicationPolicyInner withPriorityReplication(ObjectReplicationPolicyPropertiesPriorityReplication priorityReplication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withPriorityReplication(priorityReplication);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ObjectReplicationPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ObjectReplicationPolicyInner)((Object)jsonReader.readObject(reader -> {
            ObjectReplicationPolicyInner deserializedObjectReplicationPolicyInner = new ObjectReplicationPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedObjectReplicationPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedObjectReplicationPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedObjectReplicationPolicyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedObjectReplicationPolicyInner.innerProperties = ObjectReplicationPolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedObjectReplicationPolicyInner;
        }));
    }
}

