/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import java.io.IOException;
import java.util.List;

public final class StorageAccountListResult
implements JsonSerializable<StorageAccountListResult> {
    private List<StorageAccountInner> value;
    private String nextLink;

    public List<StorageAccountInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountListResult fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountListResult)jsonReader.readObject(reader -> {
            StorageAccountListResult deserializedStorageAccountListResult = new StorageAccountListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedStorageAccountListResult.value = value = reader.readArray(reader1 -> StorageAccountInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedStorageAccountListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountListResult;
        });
    }
}

