/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.StorageAccountInternetEndpoints;
import com.azure.resourcemanager.storage.models.StorageAccountMicrosoftEndpoints;
import java.io.IOException;

public final class StorageAccountIpv6Endpoints
implements JsonSerializable<StorageAccountIpv6Endpoints> {
    private String blob;
    private String queue;
    private String table;
    private String file;
    private String web;
    private String dfs;
    private StorageAccountMicrosoftEndpoints microsoftEndpoints;
    private StorageAccountInternetEndpoints internetEndpoints;

    public String blob() {
        return this.blob;
    }

    public String queue() {
        return this.queue;
    }

    public String table() {
        return this.table;
    }

    public String file() {
        return this.file;
    }

    public String web() {
        return this.web;
    }

    public String dfs() {
        return this.dfs;
    }

    public StorageAccountMicrosoftEndpoints microsoftEndpoints() {
        return this.microsoftEndpoints;
    }

    public StorageAccountIpv6Endpoints withMicrosoftEndpoints(StorageAccountMicrosoftEndpoints microsoftEndpoints) {
        this.microsoftEndpoints = microsoftEndpoints;
        return this;
    }

    public StorageAccountInternetEndpoints internetEndpoints() {
        return this.internetEndpoints;
    }

    public StorageAccountIpv6Endpoints withInternetEndpoints(StorageAccountInternetEndpoints internetEndpoints) {
        this.internetEndpoints = internetEndpoints;
        return this;
    }

    public void validate() {
        if (this.microsoftEndpoints() != null) {
            this.microsoftEndpoints().validate();
        }
        if (this.internetEndpoints() != null) {
            this.internetEndpoints().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("microsoftEndpoints", (JsonSerializable)this.microsoftEndpoints);
        jsonWriter.writeJsonField("internetEndpoints", (JsonSerializable)this.internetEndpoints);
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountIpv6Endpoints fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountIpv6Endpoints)jsonReader.readObject(reader -> {
            StorageAccountIpv6Endpoints deserializedStorageAccountIpv6Endpoints = new StorageAccountIpv6Endpoints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blob".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.blob = reader.getString();
                    continue;
                }
                if ("queue".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.queue = reader.getString();
                    continue;
                }
                if ("table".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.table = reader.getString();
                    continue;
                }
                if ("file".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.file = reader.getString();
                    continue;
                }
                if ("web".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.web = reader.getString();
                    continue;
                }
                if ("dfs".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.dfs = reader.getString();
                    continue;
                }
                if ("microsoftEndpoints".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.microsoftEndpoints = StorageAccountMicrosoftEndpoints.fromJson(reader);
                    continue;
                }
                if ("internetEndpoints".equals(fieldName)) {
                    deserializedStorageAccountIpv6Endpoints.internetEndpoints = StorageAccountInternetEndpoints.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountIpv6Endpoints;
        });
    }
}

