/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.Name;
import java.io.IOException;
import java.util.List;

public final class LastAccessTimeTrackingPolicy
implements JsonSerializable<LastAccessTimeTrackingPolicy> {
    private boolean enable;
    private Name name;
    private Integer trackingGranularityInDays;
    private List<String> blobType;

    public boolean enable() {
        return this.enable;
    }

    public LastAccessTimeTrackingPolicy withEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public Name name() {
        return this.name;
    }

    public LastAccessTimeTrackingPolicy withName(Name name) {
        this.name = name;
        return this;
    }

    public Integer trackingGranularityInDays() {
        return this.trackingGranularityInDays;
    }

    public LastAccessTimeTrackingPolicy withTrackingGranularityInDays(Integer trackingGranularityInDays) {
        this.trackingGranularityInDays = trackingGranularityInDays;
        return this;
    }

    public List<String> blobType() {
        return this.blobType;
    }

    public LastAccessTimeTrackingPolicy withBlobType(List<String> blobType) {
        this.blobType = blobType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enable", this.enable);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("trackingGranularityInDays", (Number)this.trackingGranularityInDays);
        jsonWriter.writeArrayField("blobType", this.blobType, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static LastAccessTimeTrackingPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (LastAccessTimeTrackingPolicy)jsonReader.readObject(reader -> {
            LastAccessTimeTrackingPolicy deserializedLastAccessTimeTrackingPolicy = new LastAccessTimeTrackingPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enable".equals(fieldName)) {
                    deserializedLastAccessTimeTrackingPolicy.enable = reader.getBoolean();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLastAccessTimeTrackingPolicy.name = Name.fromString(reader.getString());
                    continue;
                }
                if ("trackingGranularityInDays".equals(fieldName)) {
                    deserializedLastAccessTimeTrackingPolicy.trackingGranularityInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("blobType".equals(fieldName)) {
                    List blobType;
                    deserializedLastAccessTimeTrackingPolicy.blobType = blobType = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLastAccessTimeTrackingPolicy;
        });
    }
}

