/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentExecutionContext;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentReport;
import com.azure.resourcemanager.storage.models.StorageTaskReportProperties;
import java.io.IOException;

public final class StorageTaskAssignmentProperties
implements JsonSerializable<StorageTaskAssignmentProperties> {
    private String taskId;
    private boolean enabled;
    private String description;
    private StorageTaskAssignmentExecutionContext executionContext;
    private StorageTaskAssignmentReport report;
    private ProvisioningState provisioningState;
    private StorageTaskReportProperties runStatus;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentProperties.class);

    public String taskId() {
        return this.taskId;
    }

    public StorageTaskAssignmentProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public StorageTaskAssignmentProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String description() {
        return this.description;
    }

    public StorageTaskAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public StorageTaskAssignmentExecutionContext executionContext() {
        return this.executionContext;
    }

    public StorageTaskAssignmentProperties withExecutionContext(StorageTaskAssignmentExecutionContext executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public StorageTaskAssignmentReport report() {
        return this.report;
    }

    public StorageTaskAssignmentProperties withReport(StorageTaskAssignmentReport report) {
        this.report = report;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public StorageTaskReportProperties runStatus() {
        return this.runStatus;
    }

    public StorageTaskAssignmentProperties withRunStatus(StorageTaskReportProperties runStatus) {
        this.runStatus = runStatus;
        return this;
    }

    public void validate() {
        if (this.taskId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taskId in model StorageTaskAssignmentProperties"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model StorageTaskAssignmentProperties"));
        }
        if (this.executionContext() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property executionContext in model StorageTaskAssignmentProperties"));
        }
        this.executionContext().validate();
        if (this.report() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property report in model StorageTaskAssignmentProperties"));
        }
        this.report().validate();
        if (this.runStatus() != null) {
            this.runStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("executionContext", (JsonSerializable)this.executionContext);
        jsonWriter.writeJsonField("report", (JsonSerializable)this.report);
        jsonWriter.writeJsonField("runStatus", (JsonSerializable)this.runStatus);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskAssignmentProperties)jsonReader.readObject(reader -> {
            StorageTaskAssignmentProperties deserializedStorageTaskAssignmentProperties = new StorageTaskAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskId".equals(fieldName)) {
                    deserializedStorageTaskAssignmentProperties.taskId = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedStorageTaskAssignmentProperties.enabled = reader.getBoolean();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedStorageTaskAssignmentProperties.description = reader.getString();
                    continue;
                }
                if ("executionContext".equals(fieldName)) {
                    deserializedStorageTaskAssignmentProperties.executionContext = StorageTaskAssignmentExecutionContext.fromJson(reader);
                    continue;
                }
                if ("report".equals(fieldName)) {
                    deserializedStorageTaskAssignmentProperties.report = StorageTaskAssignmentReport.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageTaskAssignmentProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("runStatus".equals(fieldName)) {
                    deserializedStorageTaskAssignmentProperties.runStatus = StorageTaskReportProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskAssignmentProperties;
        });
    }
}

