/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.fluent.models.ImmutabilityPolicyProperty;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import com.azure.resourcemanager.storage.models.UpdateHistoryProperty;
import java.io.IOException;
import java.util.List;

public final class ImmutabilityPolicyProperties
implements JsonSerializable<ImmutabilityPolicyProperties> {
    private ImmutabilityPolicyProperty innerProperties;
    private String etag;
    private List<UpdateHistoryProperty> updateHistory;

    private ImmutabilityPolicyProperty innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public List<UpdateHistoryProperty> updateHistory() {
        return this.updateHistory;
    }

    public Integer immutabilityPeriodSinceCreationInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().immutabilityPeriodSinceCreationInDays();
    }

    public ImmutabilityPolicyProperties withImmutabilityPeriodSinceCreationInDays(Integer immutabilityPeriodSinceCreationInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
        return this;
    }

    public ImmutabilityPolicyState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public Boolean allowProtectedAppendWrites() {
        return this.innerProperties() == null ? null : this.innerProperties().allowProtectedAppendWrites();
    }

    public ImmutabilityPolicyProperties withAllowProtectedAppendWrites(Boolean allowProtectedAppendWrites) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withAllowProtectedAppendWrites(allowProtectedAppendWrites);
        return this;
    }

    public Boolean allowProtectedAppendWritesAll() {
        return this.innerProperties() == null ? null : this.innerProperties().allowProtectedAppendWritesAll();
    }

    public ImmutabilityPolicyProperties withAllowProtectedAppendWritesAll(Boolean allowProtectedAppendWritesAll) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withAllowProtectedAppendWritesAll(allowProtectedAppendWritesAll);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.updateHistory() != null) {
            this.updateHistory().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ImmutabilityPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ImmutabilityPolicyProperties)jsonReader.readObject(reader -> {
            ImmutabilityPolicyProperties deserializedImmutabilityPolicyProperties = new ImmutabilityPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperties.innerProperties = ImmutabilityPolicyProperty.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperties.etag = reader.getString();
                    continue;
                }
                if ("updateHistory".equals(fieldName)) {
                    List updateHistory;
                    deserializedImmutabilityPolicyProperties.updateHistory = updateHistory = reader.readArray(reader1 -> UpdateHistoryProperty.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImmutabilityPolicyProperties;
        });
    }
}

