/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storage.fluent.TableServicesClient;
import com.azure.resourcemanager.storage.fluent.models.ListTableServicesInner;
import com.azure.resourcemanager.storage.fluent.models.TableServicePropertiesInner;
import com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import reactor.core.publisher.Mono;

public final class TableServicesClientImpl
implements TableServicesClient {
    private final TableServicesService service;
    private final StorageManagementClientImpl client;

    TableServicesClientImpl(StorageManagementClientImpl client) {
        this.service = (TableServicesService)RestProxy.create(TableServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListTableServicesInner>> listWithResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ListTableServicesInner>> listWithResponseAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListTableServicesInner> listAsync(String resourceGroupName, String accountName) {
        return this.listWithResponseAsync(resourceGroupName, accountName).flatMap(res -> Mono.justOrEmpty((Object)((ListTableServicesInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListTableServicesInner> listWithResponse(String resourceGroupName, String accountName, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, accountName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListTableServicesInner list(String resourceGroupName, String accountName) {
        return (ListTableServicesInner)this.listWithResponse(resourceGroupName, accountName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableServicePropertiesInner>> setServicePropertiesWithResponseAsync(String resourceGroupName, String accountName, TableServicePropertiesInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String tableServiceName = "default";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TableServicePropertiesInner>> setServicePropertiesWithResponseAsync(String resourceGroupName, String accountName, TableServicePropertiesInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String tableServiceName = "default";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, TableServicePropertiesInner parameters) {
        return this.setServicePropertiesWithResponseAsync(resourceGroupName, accountName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TableServicePropertiesInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServicePropertiesInner> setServicePropertiesWithResponse(String resourceGroupName, String accountName, TableServicePropertiesInner parameters, Context context) {
        return (Response)this.setServicePropertiesWithResponseAsync(resourceGroupName, accountName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName, TableServicePropertiesInner parameters) {
        return (TableServicePropertiesInner)((Object)this.setServicePropertiesWithResponse(resourceGroupName, accountName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TableServicePropertiesInner>> getServicePropertiesWithResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String tableServiceName = "default";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TableServicePropertiesInner>> getServicePropertiesWithResponseAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String tableServiceName = "default";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getServiceProperties(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "default", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.getServicePropertiesWithResponseAsync(resourceGroupName, accountName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TableServicePropertiesInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableServicePropertiesInner> getServicePropertiesWithResponse(String resourceGroupName, String accountName, Context context) {
        return (Response)this.getServicePropertiesWithResponseAsync(resourceGroupName, accountName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableServicePropertiesInner getServiceProperties(String resourceGroupName, String accountName) {
        return (TableServicePropertiesInner)((Object)this.getServicePropertiesWithResponse(resourceGroupName, accountName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementClientTableServices")
    public static interface TableServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListTableServicesInner>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/{tableServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TableServicePropertiesInner>> setServiceProperties(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="tableServiceName") String var6, @BodyParam(value="application/json") TableServicePropertiesInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/{tableServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TableServicePropertiesInner>> getServiceProperties(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="tableServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

