/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeter;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationPropertiesProfile;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationProvisioningState;
import com.azure.resourcemanager.storage.models.ProvisioningIssue;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationProperties
implements JsonSerializable<NetworkSecurityPerimeterConfigurationProperties> {
    private NetworkSecurityPerimeterConfigurationProvisioningState provisioningState;
    private List<ProvisioningIssue> provisioningIssues;
    private NetworkSecurityPerimeter networkSecurityPerimeter;
    private NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation;
    private NetworkSecurityPerimeterConfigurationPropertiesProfile profile;

    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ProvisioningIssue> provisioningIssues() {
        return this.provisioningIssues;
    }

    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.networkSecurityPerimeter;
    }

    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation() {
        return this.resourceAssociation;
    }

    public NetworkSecurityPerimeterConfigurationPropertiesProfile profile() {
        return this.profile;
    }

    public void validate() {
        if (this.provisioningIssues() != null) {
            this.provisioningIssues().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeter() != null) {
            this.networkSecurityPerimeter().validate();
        }
        if (this.resourceAssociation() != null) {
            this.resourceAssociation().validate();
        }
        if (this.profile() != null) {
            this.profile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfigurationProperties)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationProperties deserializedNetworkSecurityPerimeterConfigurationProperties = new NetworkSecurityPerimeterConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningState = NetworkSecurityPerimeterConfigurationProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningIssues".equals(fieldName)) {
                    List provisioningIssues;
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningIssues = provisioningIssues = reader.readArray(reader1 -> ProvisioningIssue.fromJson(reader1));
                    continue;
                }
                if ("networkSecurityPerimeter".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.networkSecurityPerimeter = NetworkSecurityPerimeter.fromJson(reader);
                    continue;
                }
                if ("resourceAssociation".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.resourceAssociation = NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation.fromJson(reader);
                    continue;
                }
                if ("profile".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.profile = NetworkSecurityPerimeterConfigurationPropertiesProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationProperties;
        });
    }
}

