/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ExecutionTarget;
import com.azure.resourcemanager.storage.models.ExecutionTrigger;
import java.io.IOException;

public final class StorageTaskAssignmentExecutionContext
implements JsonSerializable<StorageTaskAssignmentExecutionContext> {
    private ExecutionTarget target;
    private ExecutionTrigger trigger;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentExecutionContext.class);

    public ExecutionTarget target() {
        return this.target;
    }

    public StorageTaskAssignmentExecutionContext withTarget(ExecutionTarget target) {
        this.target = target;
        return this;
    }

    public ExecutionTrigger trigger() {
        return this.trigger;
    }

    public StorageTaskAssignmentExecutionContext withTrigger(ExecutionTrigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public void validate() {
        if (this.target() != null) {
            this.target().validate();
        }
        if (this.trigger() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property trigger in model StorageTaskAssignmentExecutionContext"));
        }
        this.trigger().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("trigger", (JsonSerializable)this.trigger);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskAssignmentExecutionContext fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskAssignmentExecutionContext)jsonReader.readObject(reader -> {
            StorageTaskAssignmentExecutionContext deserializedStorageTaskAssignmentExecutionContext = new StorageTaskAssignmentExecutionContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trigger".equals(fieldName)) {
                    deserializedStorageTaskAssignmentExecutionContext.trigger = ExecutionTrigger.fromJson(reader);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedStorageTaskAssignmentExecutionContext.target = ExecutionTarget.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskAssignmentExecutionContext;
        });
    }
}

