/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import java.io.IOException;

public final class ImmutabilityPolicyProperty
implements JsonSerializable<ImmutabilityPolicyProperty> {
    private Integer immutabilityPeriodSinceCreationInDays;
    private ImmutabilityPolicyState state;
    private Boolean allowProtectedAppendWrites;
    private Boolean allowProtectedAppendWritesAll;

    public Integer immutabilityPeriodSinceCreationInDays() {
        return this.immutabilityPeriodSinceCreationInDays;
    }

    public ImmutabilityPolicyProperty withImmutabilityPeriodSinceCreationInDays(Integer immutabilityPeriodSinceCreationInDays) {
        this.immutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        return this;
    }

    public ImmutabilityPolicyState state() {
        return this.state;
    }

    public Boolean allowProtectedAppendWrites() {
        return this.allowProtectedAppendWrites;
    }

    public ImmutabilityPolicyProperty withAllowProtectedAppendWrites(Boolean allowProtectedAppendWrites) {
        this.allowProtectedAppendWrites = allowProtectedAppendWrites;
        return this;
    }

    public Boolean allowProtectedAppendWritesAll() {
        return this.allowProtectedAppendWritesAll;
    }

    public ImmutabilityPolicyProperty withAllowProtectedAppendWritesAll(Boolean allowProtectedAppendWritesAll) {
        this.allowProtectedAppendWritesAll = allowProtectedAppendWritesAll;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("immutabilityPeriodSinceCreationInDays", (Number)this.immutabilityPeriodSinceCreationInDays);
        jsonWriter.writeBooleanField("allowProtectedAppendWrites", this.allowProtectedAppendWrites);
        jsonWriter.writeBooleanField("allowProtectedAppendWritesAll", this.allowProtectedAppendWritesAll);
        return jsonWriter.writeEndObject();
    }

    public static ImmutabilityPolicyProperty fromJson(JsonReader jsonReader) throws IOException {
        return (ImmutabilityPolicyProperty)jsonReader.readObject(reader -> {
            ImmutabilityPolicyProperty deserializedImmutabilityPolicyProperty = new ImmutabilityPolicyProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("immutabilityPeriodSinceCreationInDays".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.immutabilityPeriodSinceCreationInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.state = ImmutabilityPolicyState.fromString(reader.getString());
                    continue;
                }
                if ("allowProtectedAppendWrites".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.allowProtectedAppendWrites = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowProtectedAppendWritesAll".equals(fieldName)) {
                    deserializedImmutabilityPolicyProperty.allowProtectedAppendWritesAll = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImmutabilityPolicyProperty;
        });
    }
}

