// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for AllowedCopyScope. */
public final class AllowedCopyScope extends ExpandableStringEnum<AllowedCopyScope> {
    /** Static value PrivateLink for AllowedCopyScope. */
    public static final AllowedCopyScope PRIVATE_LINK = fromString("PrivateLink");

    /** Static value AAD for AllowedCopyScope. */
    public static final AllowedCopyScope AAD = fromString("AAD");

    /**
     * Creates or finds a AllowedCopyScope from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AllowedCopyScope.
     */
    @JsonCreator
    public static AllowedCopyScope fromString(String name) {
        return fromString(name, AllowedCopyScope.class);
    }

    /**
     * Gets known AllowedCopyScope values.
     *
     * @return known AllowedCopyScope values.
     */
    public static Collection<AllowedCopyScope> values() {
        return values(AllowedCopyScope.class);
    }
}
