/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class ElasticPoolUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ElasticPoolUpdate.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.maxSizeBytes")
    private Long maxSizeBytes;
    @JsonProperty(value="properties.perDatabaseSettings")
    private ElasticPoolPerDatabaseSettings perDatabaseSettings;
    @JsonProperty(value="properties.zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="properties.licenseType")
    private ElasticPoolLicenseType licenseType;

    public Sku sku() {
        return this.sku;
    }

    public ElasticPoolUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ElasticPoolUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ElasticPoolUpdate withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.perDatabaseSettings;
    }

    public ElasticPoolUpdate withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        this.perDatabaseSettings = perDatabaseSettings;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ElasticPoolUpdate withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.licenseType;
    }

    public ElasticPoolUpdate withLicenseType(ElasticPoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.perDatabaseSettings() != null) {
            this.perDatabaseSettings().validate();
        }
    }
}

