/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.BackupShortTermRetentionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.models.BackupShortTermRetentionPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.BackupShortTermRetentionPolicyListResult;
import com.azure.resourcemanager.sql.models.ShortTermRetentionPolicyName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BackupShortTermRetentionPoliciesClientImpl
implements BackupShortTermRetentionPoliciesClient {
    private final ClientLogger logger = new ClientLogger(BackupShortTermRetentionPoliciesClientImpl.class);
    private final BackupShortTermRetentionPoliciesService service;
    private final SqlManagementClientImpl client;

    BackupShortTermRetentionPoliciesClientImpl(SqlManagementClientImpl client) {
        this.service = (BackupShortTermRetentionPoliciesService)RestProxy.create(BackupShortTermRetentionPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupShortTermRetentionPolicyInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, policyName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupShortTermRetentionPolicyInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, policyName, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, policyName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupShortTermRetentionPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupShortTermRetentionPolicyInner get(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName) {
        return (BackupShortTermRetentionPolicyInner)((Object)this.getAsync(resourceGroupName, serverName, databaseName, policyName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupShortTermRetentionPolicyInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, policyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, policyName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, policyName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BackupShortTermRetentionPolicyInner.class), (Type)((Object)BackupShortTermRetentionPolicyInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BackupShortTermRetentionPolicyInner.class), (Type)((Object)BackupShortTermRetentionPolicyInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return (BackupShortTermRetentionPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return (BackupShortTermRetentionPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return (BackupShortTermRetentionPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, policyName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, policyName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BackupShortTermRetentionPolicyInner.class), (Type)((Object)BackupShortTermRetentionPolicyInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BackupShortTermRetentionPolicyInner.class), (Type)((Object)BackupShortTermRetentionPolicyInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginUpdate(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner> beginUpdate(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupShortTermRetentionPolicyInner update(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return (BackupShortTermRetentionPolicyInner)((Object)this.updateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupShortTermRetentionPolicyInner update(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return (BackupShortTermRetentionPolicyInner)((Object)this.updateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupShortTermRetentionPolicyInner update(String resourceGroupName, String serverName, String databaseName, ShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return (BackupShortTermRetentionPolicyInner)((Object)this.updateAsync(resourceGroupName, serverName, databaseName, policyName, retentionDays).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupShortTermRetentionPolicyInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupShortTermRetentionPolicyInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, this.client.getSubscriptionId(), "2017-10-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BackupShortTermRetentionPolicyInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BackupShortTermRetentionPolicyInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, Context context) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, context), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupShortTermRetentionPolicyInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupShortTermRetentionPolicyInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, Context context) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupShortTermRetentionPolicyInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByDatabaseNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupShortTermRetentionPolicyInner>> listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((BackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientB")
    private static interface BackupShortTermRetentionPoliciesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BackupShortTermRetentionPolicyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="policyName") ShortTermRetentionPolicyName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="policyName") ShortTermRetentionPolicyName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") BackupShortTermRetentionPolicyInner var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="policyName") ShortTermRetentionPolicyName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") BackupShortTermRetentionPolicyInner var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BackupShortTermRetentionPolicyListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BackupShortTermRetentionPolicyListResult>> listByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

