/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.QueryMetricProperties;
import com.azure.resourcemanager.sql.models.QueryTimeGrainType;
import java.io.IOException;
import java.util.List;

public final class QueryMetricIntervalAutoGenerated
implements JsonSerializable<QueryMetricIntervalAutoGenerated> {
    private String intervalStartTime;
    private QueryTimeGrainType intervalType;
    private Long executionCount;
    private List<QueryMetricProperties> metrics;

    public String intervalStartTime() {
        return this.intervalStartTime;
    }

    public QueryTimeGrainType intervalType() {
        return this.intervalType;
    }

    public Long executionCount() {
        return this.executionCount;
    }

    public List<QueryMetricProperties> metrics() {
        return this.metrics;
    }

    public QueryMetricIntervalAutoGenerated withMetrics(List<QueryMetricProperties> metrics) {
        this.metrics = metrics;
        return this;
    }

    public void validate() {
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static QueryMetricIntervalAutoGenerated fromJson(JsonReader jsonReader) throws IOException {
        return (QueryMetricIntervalAutoGenerated)jsonReader.readObject(reader -> {
            QueryMetricIntervalAutoGenerated deserializedQueryMetricIntervalAutoGenerated = new QueryMetricIntervalAutoGenerated();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("intervalStartTime".equals(fieldName)) {
                    deserializedQueryMetricIntervalAutoGenerated.intervalStartTime = reader.getString();
                    continue;
                }
                if ("intervalType".equals(fieldName)) {
                    deserializedQueryMetricIntervalAutoGenerated.intervalType = QueryTimeGrainType.fromString(reader.getString());
                    continue;
                }
                if ("executionCount".equals(fieldName)) {
                    deserializedQueryMetricIntervalAutoGenerated.executionCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List metrics;
                    deserializedQueryMetricIntervalAutoGenerated.metrics = metrics = reader.readArray(reader1 -> QueryMetricProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryMetricIntervalAutoGenerated;
        });
    }
}

