/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.NetworkIsolationSettings;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import java.io.IOException;

public final class ImportExistingDatabaseDefinition
implements JsonSerializable<ImportExistingDatabaseDefinition> {
    private StorageKeyType storageKeyType;
    private String storageKey;
    private String storageUri;
    private String administratorLogin;
    private String administratorLoginPassword;
    private String authenticationType;
    private NetworkIsolationSettings networkIsolation;
    private static final ClientLogger LOGGER = new ClientLogger(ImportExistingDatabaseDefinition.class);

    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    public ImportExistingDatabaseDefinition withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public ImportExistingDatabaseDefinition withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public ImportExistingDatabaseDefinition withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ImportExistingDatabaseDefinition withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ImportExistingDatabaseDefinition withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    public ImportExistingDatabaseDefinition withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public NetworkIsolationSettings networkIsolation() {
        return this.networkIsolation;
    }

    public ImportExistingDatabaseDefinition withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        this.networkIsolation = networkIsolation;
        return this;
    }

    public void validate() {
        if (this.storageKeyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageKeyType in model ImportExistingDatabaseDefinition"));
        }
        if (this.storageKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageKey in model ImportExistingDatabaseDefinition"));
        }
        if (this.storageUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageUri in model ImportExistingDatabaseDefinition"));
        }
        if (this.administratorLogin() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorLogin in model ImportExistingDatabaseDefinition"));
        }
        if (this.administratorLoginPassword() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorLoginPassword in model ImportExistingDatabaseDefinition"));
        }
        if (this.networkIsolation() != null) {
            this.networkIsolation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageKeyType", this.storageKeyType == null ? null : this.storageKeyType.toString());
        jsonWriter.writeStringField("storageKey", this.storageKey);
        jsonWriter.writeStringField("storageUri", this.storageUri);
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("authenticationType", this.authenticationType);
        jsonWriter.writeJsonField("networkIsolation", (JsonSerializable)this.networkIsolation);
        return jsonWriter.writeEndObject();
    }

    public static ImportExistingDatabaseDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ImportExistingDatabaseDefinition)jsonReader.readObject(reader -> {
            ImportExistingDatabaseDefinition deserializedImportExistingDatabaseDefinition = new ImportExistingDatabaseDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageKeyType".equals(fieldName)) {
                    deserializedImportExistingDatabaseDefinition.storageKeyType = StorageKeyType.fromString(reader.getString());
                    continue;
                }
                if ("storageKey".equals(fieldName)) {
                    deserializedImportExistingDatabaseDefinition.storageKey = reader.getString();
                    continue;
                }
                if ("storageUri".equals(fieldName)) {
                    deserializedImportExistingDatabaseDefinition.storageUri = reader.getString();
                    continue;
                }
                if ("administratorLogin".equals(fieldName)) {
                    deserializedImportExistingDatabaseDefinition.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedImportExistingDatabaseDefinition.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedImportExistingDatabaseDefinition.authenticationType = reader.getString();
                    continue;
                }
                if ("networkIsolation".equals(fieldName)) {
                    deserializedImportExistingDatabaseDefinition.networkIsolation = NetworkIsolationSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportExistingDatabaseDefinition;
        });
    }
}

