/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.InstanceRole;
import com.azure.resourcemanager.sql.models.RoleChangeType;
import java.io.IOException;

public final class DistributedAvailabilityGroupSetRole
implements JsonSerializable<DistributedAvailabilityGroupSetRole> {
    private InstanceRole instanceRole;
    private RoleChangeType roleChangeType;
    private static final ClientLogger LOGGER = new ClientLogger(DistributedAvailabilityGroupSetRole.class);

    public InstanceRole instanceRole() {
        return this.instanceRole;
    }

    public DistributedAvailabilityGroupSetRole withInstanceRole(InstanceRole instanceRole) {
        this.instanceRole = instanceRole;
        return this;
    }

    public RoleChangeType roleChangeType() {
        return this.roleChangeType;
    }

    public DistributedAvailabilityGroupSetRole withRoleChangeType(RoleChangeType roleChangeType) {
        this.roleChangeType = roleChangeType;
        return this;
    }

    public void validate() {
        if (this.instanceRole() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property instanceRole in model DistributedAvailabilityGroupSetRole"));
        }
        if (this.roleChangeType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property roleChangeType in model DistributedAvailabilityGroupSetRole"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("instanceRole", this.instanceRole == null ? null : this.instanceRole.toString());
        jsonWriter.writeStringField("roleChangeType", this.roleChangeType == null ? null : this.roleChangeType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DistributedAvailabilityGroupSetRole fromJson(JsonReader jsonReader) throws IOException {
        return (DistributedAvailabilityGroupSetRole)jsonReader.readObject(reader -> {
            DistributedAvailabilityGroupSetRole deserializedDistributedAvailabilityGroupSetRole = new DistributedAvailabilityGroupSetRole();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("instanceRole".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupSetRole.instanceRole = InstanceRole.fromString(reader.getString());
                    continue;
                }
                if ("roleChangeType".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupSetRole.roleChangeType = RoleChangeType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDistributedAvailabilityGroupSetRole;
        });
    }
}

