/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.SqlVulnerabilityAssessmentRuleBaselinesClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.BaselineName;
import com.azure.resourcemanager.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineInput;
import com.azure.resourcemanager.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import reactor.core.publisher.Mono;

public final class SqlVulnerabilityAssessmentRuleBaselinesClientImpl
implements SqlVulnerabilityAssessmentRuleBaselinesClient {
    private final SqlVulnerabilityAssessmentRuleBaselinesService service;
    private final SqlManagementClientImpl client;

    SqlVulnerabilityAssessmentRuleBaselinesClientImpl(SqlManagementClientImpl client) {
        this.service = (SqlVulnerabilityAssessmentRuleBaselinesService)RestProxy.create(SqlVulnerabilityAssessmentRuleBaselinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> listByBaselineSinglePageAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByBaseline(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).value(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> listByBaselineSinglePageAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByBaseline(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).value(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> listByBaselineAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName) {
        return new PagedFlux(() -> this.listByBaselineSinglePageAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName), nextLink -> this.listByBaselineNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> listByBaselineAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, Context context) {
        return new PagedFlux(() -> this.listByBaselineSinglePageAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, context), nextLink -> this.listByBaselineNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> listByBaseline(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName) {
        return new PagedIterable(this.listByBaselineAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> listByBaseline(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, Context context) {
        return new PagedIterable(this.listByBaselineAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, "master", this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId) {
        return this.getWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseSqlVulnerabilityAssessmentRuleBaselineInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> getWithResponse(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseSqlVulnerabilityAssessmentRuleBaselineInner get(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId) {
        return (DatabaseSqlVulnerabilityAssessmentRuleBaselineInner)((Object)this.getWithResponse(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId, DatabaseSqlVulnerabilityAssessmentRuleBaselineInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, "master", this.client.getSubscriptionId(), "2022-11-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId, DatabaseSqlVulnerabilityAssessmentRuleBaselineInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String systemDatabaseName = "master";
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, "master", this.client.getSubscriptionId(), "2022-11-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId, DatabaseSqlVulnerabilityAssessmentRuleBaselineInput parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseSqlVulnerabilityAssessmentRuleBaselineInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId, DatabaseSqlVulnerabilityAssessmentRuleBaselineInput parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseSqlVulnerabilityAssessmentRuleBaselineInner createOrUpdate(String resourceGroupName, String serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, BaselineName baselineName, String ruleId, DatabaseSqlVulnerabilityAssessmentRuleBaselineInput parameters) {
        return (DatabaseSqlVulnerabilityAssessmentRuleBaselineInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleId, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> listByBaselineNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByBaselineNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).value(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> listByBaselineNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByBaselineNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).value(), ((DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientSqlVulnerabilityAssessmentRuleBaselines")
    public static interface SqlVulnerabilityAssessmentRuleBaselinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult>> listByBaseline(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var4, @PathParam(value="baselineName") BaselineName var5, @QueryParam(value="systemDatabaseName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var4, @PathParam(value="baselineName") BaselineName var5, @PathParam(value="ruleId") String var6, @QueryParam(value="systemDatabaseName") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var4, @PathParam(value="baselineName") BaselineName var5, @PathParam(value="ruleId") String var6, @QueryParam(value="systemDatabaseName") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @BodyParam(value="application/json") DatabaseSqlVulnerabilityAssessmentRuleBaselineInput var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult>> listByBaselineNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

