/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ServerSecurityAlertPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerSecurityAlertPolicyImpl;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicy;
import com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlServerSecurityAlertPolicyOperationsImpl
implements SqlServerSecurityAlertPolicyOperations,
SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected SqlServer sqlServer;

    SqlServerSecurityAlertPolicyOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
    }

    SqlServerSecurityAlertPolicyOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl define() {
        SqlServerSecurityAlertPolicyImpl result = new SqlServerSecurityAlertPolicyImpl(new ServerSecurityAlertPolicyInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }

    @Override
    public SqlServerSecurityAlertPolicy get() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer);
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer);
    }

    @Override
    public SqlServerSecurityAlertPolicy getBySqlServer(String resourceGroupName, String sqlServerName) {
        ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().get(resourceGroupName, sqlServerName, SecurityAlertPolicyName.DEFAULT);
        return serverSecurityAlertPolicyInner != null ? new SqlServerSecurityAlertPolicyImpl(resourceGroupName, sqlServerName, serverSecurityAlertPolicyInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        SqlServerSecurityAlertPolicyOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().getAsync(resourceGroupName, sqlServerName, SecurityAlertPolicyName.DEFAULT).map(serverSecurityAlertPolicyInner -> new SqlServerSecurityAlertPolicyImpl(resourceGroupName, sqlServerName, (ServerSecurityAlertPolicyInner)((Object)serverSecurityAlertPolicyInner), self.sqlServerManager));
    }

    @Override
    public SqlServerSecurityAlertPolicy getBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerSecurityAlertPolicies().get(sqlServer.resourceGroupName(), sqlServer.name(), SecurityAlertPolicyName.DEFAULT);
        return serverSecurityAlertPolicyInner != null ? new SqlServerSecurityAlertPolicyImpl((SqlServerImpl)sqlServer, serverSecurityAlertPolicyInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getBySqlServerAsync(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerSecurityAlertPolicies().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), SecurityAlertPolicyName.DEFAULT).map(serverSecurityAlertPolicyInner -> new SqlServerSecurityAlertPolicyImpl((SqlServerImpl)sqlServer, (ServerSecurityAlertPolicyInner)((Object)serverSecurityAlertPolicyInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public SqlServerSecurityAlertPolicy getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }
}

