/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ServerSecurityAlertPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicy;
import com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlServerSecurityAlertPolicyImpl
extends ExternalChildResourceImpl<SqlServerSecurityAlertPolicy, ServerSecurityAlertPolicyInner, SqlServerImpl, SqlServer>
implements SqlServerSecurityAlertPolicy,
SqlServerSecurityAlertPolicy.Update,
SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlServerSecurityAlertPolicyImpl(SqlServerImpl parent, ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlServerSecurityAlertPolicyImpl(String resourceGroupName, String sqlServerName, ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlServerSecurityAlertPolicyImpl(ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String id() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).id();
    }

    public String name() {
        return "Default";
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).id());
    }

    @Override
    public SecurityAlertPolicyState state() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).state() == null ? null : SecurityAlertPolicyState.fromString(((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).state().toString());
    }

    @Override
    public List<String> disabledAlerts() {
        return Collections.unmodifiableList(((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).disabledAlerts());
    }

    @Override
    public List<String> emailAddresses() {
        return Collections.unmodifiableList(((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).emailAddresses());
    }

    @Override
    public boolean emailAccountAdmins() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).emailAccountAdmins();
    }

    @Override
    public String storageEndpoint() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).retentionDays();
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    public SqlServerSecurityAlertPolicyImpl update() {
        super.prepareUpdate();
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageEndpoint(null);
        return this;
    }

    public Mono<SqlServerSecurityAlertPolicy> createResourceAsync() {
        SqlServerSecurityAlertPolicyImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, SecurityAlertPolicyName.DEFAULT, (ServerSecurityAlertPolicyInner)((Object)self.innerModel())).map(serverSecurityAlertPolicyInner -> {
            self.setInner(serverSecurityAlertPolicyInner);
            return self;
        });
    }

    public Mono<SqlServerSecurityAlertPolicy> updateResourceAsync() {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageEndpoint(null);
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return null;
    }

    protected Mono<ServerSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().getAsync(this.resourceGroupName, this.sqlServerName, SecurityAlertPolicyName.DEFAULT);
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withState(SecurityAlertPolicyState state) {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withState(state);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withEmailAccountAdmins() {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAccountAdmins(true);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withoutEmailAccountAdmins() {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAccountAdmins(false);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withStorageEndpoint(String storageEndpointUri, String storageAccessKey) {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageEndpoint(storageEndpointUri);
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageAccountAccessKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withEmailAddresses(String ... emailAddresses) {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAddresses(Arrays.asList(emailAddresses));
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withDisabledAlerts(String ... disabledAlerts) {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withDisabledAlerts(Arrays.asList(disabledAlerts));
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withRetentionDays(int days) {
        ((ServerSecurityAlertPolicyInner)((Object)this.innerModel())).withRetentionDays(days);
        return this;
    }
}

