/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentRuleBaselinesClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentRuleBaselineInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentPolicyBaselineName;
import reactor.core.publisher.Mono;

public final class DatabaseVulnerabilityAssessmentRuleBaselinesClientImpl
implements DatabaseVulnerabilityAssessmentRuleBaselinesClient {
    private final DatabaseVulnerabilityAssessmentRuleBaselinesService service;
    private final SqlManagementClientImpl client;

    DatabaseVulnerabilityAssessmentRuleBaselinesClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseVulnerabilityAssessmentRuleBaselinesService)RestProxy.create(DatabaseVulnerabilityAssessmentRuleBaselinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2020-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentRuleBaselineInner get(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)this.getWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2020-11-01-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2020-11-01-preview", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentRuleBaselineInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineInner parameters) {
        return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2020-11-01-preview", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2020-11-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        this.deleteWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientDatabaseVulnerabilityAssessmentRuleBaselines")
    public static interface DatabaseVulnerabilityAssessmentRuleBaselinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="ruleId") String var6, @PathParam(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="ruleId") String var6, @PathParam(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @BodyParam(value="application/json") DatabaseVulnerabilityAssessmentRuleBaselineInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="ruleId") String var6, @PathParam(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, Context var10);
    }
}

